# Page Header Migration Plan

## Pages Requiring Header Component Integration

### Priority 1: List/Index Pages with Action Buttons

#### 1. **activity.php** ✅ READY TO MIGRATE
- **Current:** Custom header with breadcrumbs (Settings > Workspace > Activity Log)
- **Actions:** Team (secondary), Settings (primary)
- **Breadcrumbs:** Settings → Workspace Name → Activity Log
- **Icon:** Activity/List icon

#### 2. **clients.php** ✅ READY TO MIGRATE
- **Current:** Custom header with breadcrumbs
- **Actions:** New Client (primary)
- **Breadcrumbs:** Dashboard → Clients
- **Icon:** Users icon

#### 3. **proposals.php** ✅ READY TO MIGRATE
- **Current:** Custom header with breadcrumbs
- **Actions:** New proposal (primary)
- **Breadcrumbs:** Workspace → All proposals
- **Icon:** Document check icon

#### 4. **contracts.php** ✅ READY TO MIGRATE
- **Current:** Custom header (simple)
- **Actions:** New contract (primary)
- **Breadcrumbs:** Dashboard → Contracts
- **Icon:** Document icon

#### 5. **invoices.php** ✅ READY TO MIGRATE
- **Current:** Custom header (simple)
- **Actions:** New Invoice (primary)
- **Breadcrumbs:** Dashboard → Invoices
- **Icon:** Receipt icon

#### 6. **billing.php** ✅ READY TO MIGRATE
- **Current:** Custom header with breadcrumbs
- **Actions:** Settings (secondary), New Workspace (primary)
- **Breadcrumbs:** Profile → Billing
- **Icon:** Credit card icon

#### 7. **members.php** ✅ READY TO MIGRATE
- **Current:** Needs header component
- **Actions:** Invite Member (primary)
- **Breadcrumbs:** Dashboard → Team
- **Icon:** Users icon

#### 8. **projects.php** ✅ READY TO MIGRATE
- **Current:** Needs header component
- **Actions:** New Project (primary)
- **Breadcrumbs:** Dashboard → Projects
- **Icon:** Folder icon

#### 9. **templates.php** ✅ READY TO MIGRATE
- **Current:** Needs header component
- **Actions:** New Template (primary)
- **Breadcrumbs:** Dashboard → Templates
- **Icon:** Template icon

#### 10. **contract_templates.php** ✅ READY TO MIGRATE
- **Current:** Needs header component
- **Actions:** New Template (primary)
- **Breadcrumbs:** Dashboard → Contract Templates
- **Icon:** Document template icon

#### 11. **modules.php** ✅ READY TO MIGRATE
- **Current:** Needs header component
- **Actions:** New Module (primary)
- **Breadcrumbs:** Dashboard → Modules
- **Icon:** Puzzle icon

#### 12. **labels.php** ✅ READY TO MIGRATE
- **Current:** Needs header component
- **Actions:** New Label (primary)
- **Breadcrumbs:** Settings → Labels
- **Icon:** Tag icon

#### 13. **roles.php** ✅ READY TO MIGRATE
- **Current:** Needs header component
- **Actions:** New Role (primary)
- **Breadcrumbs:** Settings → Roles
- **Icon:** Shield icon

### Priority 2: Settings/Configuration Pages

#### 14. **settings.php** ✅ READY TO MIGRATE
- **Current:** Needs header component
- **Actions:** Save (primary)
- **Breadcrumbs:** Dashboard → Settings
- **Icon:** Settings icon

#### 15. **invoice_settings.php** ✅ READY TO MIGRATE
- **Current:** Custom header (simple)
- **Actions:** None (settings badge only)
- **Breadcrumbs:** Dashboard → Invoice Settings
- **Icon:** Settings icon

#### 16. **profile.php** ✅ READY TO MIGRATE
- **Current:** Needs header component
- **Actions:** Edit Profile (secondary)
- **Breadcrumbs:** Profile
- **Icon:** User icon

### Priority 3: Detail/View Pages

#### 17. **project.php** (single project view)
- **Current:** Needs header component
- **Actions:** Edit (secondary), Settings (secondary)
- **Breadcrumbs:** Projects → [Project Name]
- **Icon:** Folder icon

#### 18. **task.php** (single task view)
- **Current:** Needs header component
- **Actions:** Edit (secondary), Delete (danger)
- **Breadcrumbs:** Projects → [Project] → [Task]
- **Icon:** Check square icon

#### 19. **invoice_view.php**
- **Current:** Needs header component
- **Actions:** Edit (secondary), Download (secondary), Send (primary)
- **Breadcrumbs:** Invoices → [Invoice Number]
- **Icon:** Receipt icon

### Priority 4: Create/Edit Pages

#### 20. **invoice_create.php**
- **Current:** Needs header component
- **Actions:** Save Draft (secondary), Send Invoice (primary)
- **Breadcrumbs:** Invoices → New Invoice
- **Icon:** Plus icon

#### 21. **contract_create.php**
- **Current:** Needs header component
- **Actions:** Save Draft (secondary), Generate (primary)
- **Breadcrumbs:** Contracts → New Contract
- **Icon:** Plus icon

#### 22. **project-create.php**
- **Current:** Needs header component
- **Actions:** Cancel (secondary), Create Project (primary)
- **Breadcrumbs:** Projects → New Project
- **Icon:** Plus icon

#### 23. **task-create.php**
- **Current:** Needs header component
- **Actions:** Cancel (secondary), Create Task (primary)
- **Breadcrumbs:** Projects → [Project] → New Task
- **Icon:** Plus icon

#### 24. **template_create.php**
- **Current:** Needs header component
- **Actions:** Save Draft (secondary), Publish (primary)
- **Breadcrumbs:** Templates → New Template
- **Icon:** Plus icon

### Priority 5: Special Pages

#### 25. **generate.php** (Proposal Generator)
- **Current:** Needs header component
- **Actions:** Save Draft (secondary), Generate (primary)
- **Breadcrumbs:** Proposals → Generate
- **Icon:** Lightning icon

#### 26. **project-board.php** (Kanban)
- **Current:** Needs header component
- **Actions:** New Task (primary), View (dropdown)
- **Breadcrumbs:** Projects → [Project] → Board
- **Icon:** Grid icon

#### 27. **projects-calendar.php**
- **Current:** Needs header component
- **Actions:** New Event (primary), View (dropdown)
- **Breadcrumbs:** Projects → Calendar
- **Icon:** Calendar icon

### Pages NOT Requiring Header Component

- **login.php** - Standalone auth page
- **signup.php** - Standalone auth page
- **logout.php** - Redirect page
- **contract_sign.php** - Public signing page
- **project-public.php** - Public project view
- **pdf.php** - PDF generation
- **download.php** - File download
- **upload-image.php** - API endpoint
- **check-session.php** - API endpoint
- **set-workspace.php** - Redirect page
- **go-workspace.php** - Redirect page
- **switch.php** - Redirect page
- **workspace-switch.php** - Redirect page
- **footer.php** - Component file
- **navigation.php** - Component file

## Common Icon SVG Paths

```php
// Dashboard/Home
'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z'

// Users/Clients/Team
'M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z'

// Document/Contract
'M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z'

// Invoice/Receipt
'M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z'

// Settings/Gear
'M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z'

// Plus/New
'M12 4v16m8-8H4'

// Folder/Project
'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z'

// Tag/Label
'M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z'

// Shield/Role
'M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z'
```

## Implementation Order

1. **Start with index pages** (activity, clients, proposals, contracts, invoices)
2. **Then settings pages** (settings, invoice_settings, profile)
3. **Then detail pages** (project, task, invoice_view)
4. **Then create pages** (invoice_create, contract_create, etc.)
5. **Finally special pages** (generate, project-board, calendar)

## Next Steps

Run migration script for each priority group, testing after each batch.
