# Pages Requiring Header Migration - Status

## ✅ Completed

1. **index.php** - Dashboard (Already has renderPageHeader)
2. **activity.php** - Activity Log (Just migrated)

## 🔄 Ready to Migrate - Priority 1 (List Pages)

### clients.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => htmlspecialchars($activeWorkspaceName), 'url' => '/index.php', 'icon' => 'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z']
    ],
    currentPage: 'Clients',
    actions: [
        ['label' => 'New Client', 'url' => '/clients.php?action=create', 'type' => 'primary', 'icon' => 'M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z', 'append_workspace' => true]
    ],
    workspaceQuery: $workspaceQuery
);
```

### proposals.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => htmlspecialchars($companyDisplayName), 'url' => '/index.php', 'icon' => 'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z']
    ],
    currentPage: 'All proposals',
    actions: [
        ['label' => 'New proposal', 'url' => '/generate.php', 'type' => 'primary', 'icon' => 'M12 4v16m8-8H4', 'append_workspace' => true]
    ],
    workspaceQuery: $workspaceQuery
);
```

### contracts.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => 'Dashboard', 'url' => '/index.php', 'icon' => 'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z']
    ],
    currentPage: 'Contracts',
    actions: [
        ['label' => 'New contract', 'url' => '/contract_create.php', 'type' => 'primary', 'icon' => 'M12 4v16m8-8H4', 'append_workspace' => true]
    ],
    workspaceQuery: $workspaceQuery
);
```

### invoices.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => 'Dashboard', 'url' => '/index.php', 'icon' => 'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z']
    ],
    currentPage: 'Invoices',
    actions: [
        ['label' => 'New Invoice', 'url' => '/invoice_create.php', 'type' => 'primary', 'icon' => 'M12 4v16m8-8H4', 'append_workspace' => true]
    ],
    workspaceQuery: $workspaceQuery
);
```

### billing.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => 'Profile', 'url' => '/profile.php', 'icon' => 'M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z']
    ],
    currentPage: 'Billing',
    actions: [
        ['label' => 'Settings', 'url' => '/settings.php', 'type' => 'secondary', 'icon' => 'M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z', 'append_workspace' => true],
        ['label' => 'New Workspace', 'url' => '/workspace-plans.php', 'type' => 'primary', 'icon' => 'M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z', 'append_workspace' => true]
    ],
    workspaceQuery: $workspaceQuery
);
```

### members.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => htmlspecialchars($company['name'] ?? 'Workspace'), 'url' => '/index.php', 'icon' => 'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z']
    ],
    currentPage: 'Team',
    actions: [
        ['label' => 'Invite Member', 'url' => '#', 'type' => 'primary', 'icon' => 'M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z', 'id' => 'invite-member-btn']
    ],
    workspaceQuery: $workspaceQuery
);
```

### projects.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => 'Dashboard', 'url' => '/index.php', 'icon' => 'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z']
    ],
    currentPage: 'Projects',
    actions: [
        ['label' => 'New Project', 'url' => '/project-create.php', 'type' => 'primary', 'icon' => 'M12 4v16m8-8H4', 'append_workspace' => true]
    ],
    workspaceQuery: $workspaceQuery
);
```

### templates.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => 'Dashboard', 'url' => '/index.php', 'icon' => 'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z']
    ],
    currentPage: 'Templates',
    actions: [
        ['label' => 'New Template', 'url' => '/template_create.php', 'type' => 'primary', 'icon' => 'M12 4v16m8-8H4', 'append_workspace' => true]
    ],
    workspaceQuery: $workspaceQuery
);
```

### contract_templates.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => 'Dashboard', 'url' => '/index.php', 'icon' => 'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z']
    ],
    currentPage: 'Contract Templates',
    actions: [
        ['label' => 'New Template', 'url' => '/contract_template_create.php', 'type' => 'primary', 'icon' => 'M12 4v16m8-8H4', 'append_workspace' => true]
    ],
    workspaceQuery: $workspaceQuery
);
```

### modules.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => 'Dashboard', 'url' => '/index.php', 'icon' => 'M3 7v10a2 2 0 002 2h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2z']
    ],
    currentPage: 'Modules',
    actions: [
        ['label' => 'New Module', 'url' => '/module_create.php', 'type' => 'primary', 'icon' => 'M12 4v16m8-8H4', 'append_workspace' => true]
    ],
    workspaceQuery: $workspaceQuery
);
```

### labels.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => 'Settings', 'url' => '/settings.php', 'icon' => 'M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z']
    ],
    currentPage: 'Labels',
    actions: [
        ['label' => 'New Label', 'url' => '#', 'type' => 'primary', 'icon' => 'M12 4v16m8-8H4', 'id' => 'new-label-btn']
    ],
    workspaceQuery: $workspaceQuery
);
```

### roles.php
```php
renderPageHeader(
    breadcrumbs: [
        ['label' => 'Settings', 'url' => '/settings.php', 'icon' => 'M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z']
    ],
    currentPage: 'Roles & Permissions',
    actions: [
        ['label' => 'New Role', 'url' => '#', 'type' => 'primary', 'icon' => 'M12 4v16m8-8H4', 'id' => 'new-role-btn']
    ],
    workspaceQuery: $workspaceQuery
);
```

## Summary

- **Total Pages:** 27 pages need header migration
- **Completed:** 2 pages (index.php, activity.php)
- **Remaining:** 25 pages
- **Estimated Time:** ~2-3 hours for all pages

## Next Steps

1. Migrate Priority 1 list pages (clients, proposals, contracts, invoices, billing, members, projects, templates)
2. Migrate settings pages (settings, invoice_settings, profile)
3. Migrate detail/view pages
4. Migrate create/edit pages
5. Test all pages in both light and dark modes
