# Keelance - The Agency OS

Minimal PHP + SQLite + Tailwind + TinyMCE stack for building proposals iteratively.

## Phase 1 scope
- Clients CRUD (add/edit/delete/list)
- Template creation with TinyMCE header/footer and logo upload
- Template listing + preview page

## Phase 2 scope
- Module library with TinyMCE body content (add/edit/delete, default-required toggle)
- Template module management view to attach/detach modules and reorder them
- Updated navigation and dashboard to surface modules quickly

## Phase 3 scope
- Proposal generation workflow (client/template selection, module toggling, variable fill, PDF export)
- PDF export via DOMPDF with client details, header/footer, and enabled modules
- Proposal persistence (JSON payloads for modules/variables)
- Variable placeholder detection and client-profile suggestions

## Tech stack
- PHP 8+
- SQLite (single-file `storage/database.sqlite`)
- DOMPDF via Composer (`dompdf/dompdf`)
- TinyMCE via CDN
- TailwindCSS via CDN

## Setup
```bash
composer require dompdf/dompdf   # already installed, run if dependencies change
php src/init_db.php              # creates storage/database.sqlite and tables
cd public
php -S localhost:8000
```
Visit:
- `http://localhost:8000/` – dashboard
- `http://localhost:8000/clients.php` – manage clients
- `http://localhost:8000/templates.php` – manage templates
- `http://localhost:8000/template_create.php` – create/edit template with TinyMCE
- `http://localhost:8000/template_preview.php?id=1` – preview template (replace id)
- `http://localhost:8000/modules.php` – create/edit/delete reusable modules
- `http://localhost:8000/template_edit_modules.php?id=1` – attach modules to a template and reorder them
- `http://localhost:8000/generate.php` – proposal generator (5‑step wizard)

## Testing Phase 1
1. Run `php src/init_db.php` and start the PHP server.
2. Create a client via Clients page.
3. Create a template (header/footer rich text, optional logo upload).
4. Preview the template via Templates list.

## Testing Phase 2
1. Visit `modules.php` and create modules such as _Project Scope_, _Deliverables_, _Pricing Table_. Optionally mark defaults.
2. Open `template_edit_modules.php?id=<templateId>` from the Templates list and attach newly created modules.
3. Reorder modules with the Up/Down buttons and detach any you don’t want.
4. Preview the template to verify modules appear in the saved order.

## Testing Phase 3
1. Create a client and a template with attached modules (see Phase 2 steps).
2. Open `generate.php` and walk through the 4‑step wizard:
   - Step 1: Select a client.
   - Step 2: Select a template.
   - Step 3: Review attached modules, toggle enable/disable, edit content inline, and fill detected variables (e.g., {{client_name}}).
   - Step 4: Save the proposal and preview/download the PDF.
3. Verify the PDF renders client details, header/footer, and enabled modules in order.

Phase 4+ will add packages, AMC support, drag‑drop ordering, and save‑as‑template.

## UI Style Guide (Dashboard & App Shell)

This section documents the current dark, app‑like UI used on `index.php`, `projects.php`, and shared navigation. Use these patterns when updating existing pages or building new ones.

### Layout & Shell

- **Body**
  - `body` uses `bg-neutral-950` and `min-h-screen`.
  - Main layout: a flex column wrapper with the app sidebar and a main content area.
- **Sidebar navigation** (`navigation.php`)
  - Fixed left app sidebar: `fixed left-0 top-0 z-40 h-screen w-56 bg-neutral-950/95 border-r border-neutral-800 backdrop-blur`.
  - Keelance logo row: `flex h-12 items-center justify-between border-b border-neutral-800 px-3 pt-1`.
  - Logo: `h-6 w-auto`, clickable, links to dashboard:
    - With workspace: `/index.php?workspace=<username>`.
    - Without workspace: `/index.php`.
- **Main content offset**
  - On pages with the sidebar, main content root:
    - `<main class="flex-1 flex flex-col md:ml-56">` (56 = sidebar width).

### Sticky Page Header

- Each main app page (Dashboard, Projects, etc.) has a compact sticky header bar under the nav:
  - `<header class="sticky top-[47px] z-30 flex h-12 items-center justify-between px-3 md:px-6 border-b border-neutral-800 bg-neutral-950">`.
  - Left: icon (6x6) + title + subtitle.
  - Right: small actions (filters, calendar, or `New` dropdown).
- Title text: `text-sm font-semibold text-neutral-50 truncate`.
- Subtitle text: `text-xs text-neutral-400 hidden sm:block`.

### Containers & Spacing

- Page content container inside `main`:
  - `<div class="flex-1">`
  - `<div class="max-w-7xl mx-auto px-3 md:px-6 pt-6 pb-4 space-y-4">` (centered on wide screens).
- Use `space-y-4` or `space-y-6` for vertical section rhythm.
- Prefer compact paddings on cards:
  - Stats / small cards: `p-3`.
  - Summary sections (invoice, quick actions, activity): `p-3` on outer card, `p-2.5` on inner tiles.

### Colors

- **Backgrounds**
  - Page: `bg-neutral-950`.
  - Cards: `bg-neutral-900/50` or `bg-neutral-900/60`.
  - Icon chips: `bg-<color>-500/10` or `/20` on hover.
- **Borders**
  - Standard: `border border-neutral-800`.
  - Emphasis (e.g., invoice status tiles): colored borders like `border-emerald-500/30` with hover `hover:border-emerald-400/60`.
- **Text**
  - Primary: `text-neutral-50`.
  - Muted: `text-neutral-400` (secondary) and `text-neutral-500` (helper).
  - Very subtle: `text-neutral-500/ text-neutral-600` for meta or footers.
- **Accent palette** (use consistently across pages):
  - Clients: blue (`text-blue-400`, `bg-blue-500/10`).
  - Proposals: amber (`text-amber-400`, `bg-amber-500/10`).
  - Contracts: indigo (`text-indigo-400`, `bg-indigo-500/10`).
  - Invoices / money: emerald (`text-emerald-400`, `bg-emerald-500/10`).
  - Neutral metrics / generic: slate/neutral (`text-slate-200`, `bg-slate-500/20`).

### Typography

- Use Tailwind defaults (system stack) with sizes kept compact to feel "app‑like":
  - Page header titles: `text-sm font-semibold`.
  - Subtitles / descriptions: `text-xs`–`text-sm` with `text-neutral-400`.
  - Stat numbers: `text-lg font-bold` (avoid `text-2xl+` on dashboard cards).
  - Body copy in cards: `text-sm`.
  - Meta labels and badges: `text-xs font-medium`.
- Project titles (e.g., in `projects.php`) are standardized around **14px** (`text-sm`).

### Cards & Sections

- **Stats overview (Dashboard & Projects)**
  - Grid: `grid gap-3 sm:grid-cols-2 lg:grid-cols-4`.
  - Card: `bg-neutral-900/50 border border-neutral-800 rounded-lg p-3 hover:border-neutral-700 transition-all duration-300`.
  - Label: `text-xs text-neutral-500 uppercase tracking-wide font-medium`.
  - Value: `text-lg font-bold text-neutral-50 mt-1` with hover color per entity.
- **Invoice overview**
  - Section card: `bg-neutral-900/50 border border-neutral-800 rounded-lg p-3`.
  - Inner tiles: `text-center p-2.5 bg-neutral-900/60 rounded-lg border ...` with small icon chip (`w-3 h-3`).
- **Quick actions**
  - Section: `bg-neutral-900/50 border border-neutral-800 rounded-lg p-3`.
  - Each action: `flex items-center gap-3 p-2.5 border border-neutral-800 rounded-lg hover:bg-neutral-900 ...`.
  - Label: `text-sm font-medium text-neutral-50`; description: `text-xs text-neutral-500`.
- **Recent activity lists** (invoices, proposals, contracts)
  - Outer card: `bg-neutral-900/50 border border-neutral-800 rounded-lg p-3`.
  - Row: `flex items-center justify-between p-3 border border-neutral-800 rounded-lg hover:bg-neutral-900`.
  - Empty states: smaller icons, `py-4` and `w-9 h-9` icon containers.

### Buttons & Pills

- Primary header CTA (e.g., Create Project / New):
  - `inline-flex items-center gap-1.5 rounded px-2 sm:px-3 py-1.5 text-xs font-medium text-neutral-900 bg-neutral-50 hover:bg-neutral-200`.
- Secondary header buttons (filters, calendar, categories):
  - `inline-flex items-center gap-1 rounded px-2 py-1 text-xs font-medium text-neutral-400 hover:text-neutral-100 hover:bg-neutral-800`.
- Status pills / badges:
  - Pills: `inline-flex items-center px-2 py-1 rounded text-xs font-medium`.
  - Colors map to semantic state (paid/active/overdue etc.), typically `<color>-500/10` background with `<color>-300` text.

### Common CSS / JS Fixes

- **Dropdown caret visibility**
  - Ensure all dropdown icons remain visible after interactions by forcing visibility in CSS:
    - `[id^="dropdown-icon-"], #workspace-menu-icon, #user-menu-icon { opacity: 1 !important; visibility: visible !important; display: block !important; overflow: visible !important; }`.
- **Mobile sidebar toggle**
  - Use `window.openAppSidebar()` (exposed in `navigation.php`) for the mobile menu button with `id="mobile-menu-btn"`.
- **Sticky header alignment**
  - Keep sticky page headers aligned with the sidebar by using `md:ml-56` on `main` and `top-[47px]` on the sticky header.

### When Adding or Updating Pages

- Reuse:
  - The **sidebar** from `navigation.php`.
  - The **sticky header** pattern from `projects.php` / `index.php`.
  - The **card** patterns and color palette documented above.
- Avoid:
  - Light backgrounds (`bg-white`, `bg-slate-100`, etc.) on app surfaces.
  - Oversized headings or paddings that break the compact, app‑like feel.
