<?php

declare(strict_types=1);

require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/ContractModule.php';

echo "Populating contract modules...\n";

$modules = [
    // Legal Terms & Conditions
    [
        'title' => 'Terms & Conditions',
        'category' => 'legal',
        'content_html' => '<h3>Terms & Conditions</h3><p>This agreement is governed by the laws of the jurisdiction in which the services are performed. All disputes arising from this contract shall be resolved through arbitration in accordance with the rules of the American Arbitration Association.</p><p>Both parties agree to act in good faith and deal fairly with each other in all matters relating to this agreement.</p>',
        'sort_order' => 1,
        'default_required' => 1
    ],
    [
        'title' => 'Payment Terms',
        'category' => 'legal',
        'content_html' => '<h3>Payment Terms</h3><p>Payment shall be made within 30 days of invoice date. Late payments shall incur interest at a rate of 1.5% per month on the outstanding balance.</p><p>All payments shall be made in the currency specified in this agreement. The Client shall be responsible for all bank fees, taxes, and other charges associated with payment processing.</p>',
        'sort_order' => 2,
        'default_required' => 1
    ],
    [
        'title' => 'Confidentiality Agreement',
        'category' => 'legal',
        'content_html' => '<h3>Confidentiality Agreement</h3><p>Both parties agree to maintain the confidentiality of all proprietary information shared during the course of this agreement. This includes but is not limited to business plans, financial information, technical specifications, and client lists.</p><p>Confidential information shall not be disclosed to third parties without prior written consent from the disclosing party.</p>',
        'sort_order' => 3,
        'default_required' => 1
    ],
    [
        'title' => 'Intellectual Property Rights',
        'category' => 'legal',
        'content_html' => '<h3>Intellectual Property Rights</h3><p>All intellectual property rights, including copyrights, trademarks, patents, and trade secrets, developed during the course of this agreement shall remain the property of the developing party unless otherwise specified in writing.</p><p>The Client is granted a non-exclusive, perpetual license to use the deliverables for their intended business purposes.</p>',
        'sort_order' => 4,
        'default_required' => 0
    ],
    [
        'title' => 'Liability & Limitations',
        'category' => 'legal',
        'content_html' => '<h3>Liability & Limitations</h3><p>Neither party shall be liable for indirect, consequential, or punitive damages arising from this agreement. The total liability of either party shall not exceed the total value of the contract.</p><p>Each party shall maintain appropriate insurance coverage for their respective business operations.</p>',
        'sort_order' => 5,
        'default_required' => 1
    ],
    [
        'title' => 'Termination Clause',
        'category' => 'legal',
        'content_html' => '<h3>Termination Clause</h3><p>Either party may terminate this agreement with 30 days written notice. In the event of termination, the Client shall be responsible for payment for all work completed up to the termination date.</p><p>Upon termination, all confidential information shall be returned or destroyed upon request.</p>',
        'sort_order' => 6,
        'default_required' => 1
    ],
    [
        'title' => 'Dispute Resolution',
        'category' => 'legal',
        'content_html' => '<h3>Dispute Resolution</h3><p>Any disputes arising from this agreement shall first be addressed through good faith negotiations between the parties. If resolution cannot be reached, disputes shall be resolved through binding arbitration.</p><p>Arbitration shall be conducted in the jurisdiction specified in this agreement and the decision of the arbitrator shall be final and binding.</p>',
        'sort_order' => 7,
        'default_required' => 0
    ],

    // Operational Modules
    [
        'title' => 'Delivery Schedule',
        'category' => 'operational',
        'content_html' => '<h3>Delivery Schedule</h3><p>Deliverables shall be provided according to the timeline outlined in the project scope. The Service Provider shall notify the Client of any anticipated delays in advance.</p><p>The Client shall provide timely feedback and approvals to ensure project milestones are met according to the agreed schedule.</p>',
        'sort_order' => 1,
        'default_required' => 1
    ],
    [
        'title' => 'Acceptance Criteria',
        'category' => 'operational',
        'content_html' => '<h3>Acceptance Criteria</h3><p>Deliverables shall be considered accepted when they meet the specifications outlined in the project scope and pass all quality assurance tests.</p><p>The Client shall provide written acceptance within 5 business days of deliverable submission. Failure to provide acceptance within this timeframe shall constitute deemed acceptance.</p>',
        'sort_order' => 2,
        'default_required' => 1
    ],
    [
        'title' => 'Support & Maintenance',
        'category' => 'operational',
        'content_html' => '<h3>Support & Maintenance</h3><p>The Service Provider shall provide technical support for a period of 90 days following project completion. Support includes bug fixes and technical assistance during normal business hours.</p><p>Extended maintenance agreements may be negotiated separately and shall include ongoing updates, security patches, and technical support.</p>',
        'sort_order' => 3,
        'default_required' => 0
    ],
    [
        'title' => 'Training & Documentation',
        'category' => 'operational',
        'content_html' => '<h3>Training & Documentation</h3><p>The Service Provider shall provide comprehensive documentation for all deliverables, including user manuals and technical documentation as applicable.</p><p>Training sessions shall be provided to the Client\'s staff to ensure proper use and maintenance of the deliverables.</p>',
        'sort_order' => 4,
        'default_required' => 0
    ],

    // Compliance Modules
    [
        'title' => 'Data Protection & Privacy',
        'category' => 'compliance',
        'content_html' => '<h3>Data Protection & Privacy</h3><p>Both parties shall comply with all applicable data protection laws, including GDPR and CCPA where applicable. Personal data shall be processed only for the purposes specified in this agreement.</p><p>Appropriate technical and organizational measures shall be implemented to ensure the security of personal data processed under this agreement.</p>',
        'sort_order' => 1,
        'default_required' => 1
    ],
    [
        'title' => 'Industry Compliance',
        'category' => 'compliance',
        'content_html' => '<h3>Industry Compliance</h3><p>All deliverables shall comply with industry standards and regulations applicable to the Client\'s business sector. The Service Provider shall obtain all necessary permits and licenses required to perform the services.</p><p>Compliance with relevant standards such as ISO, SOC 2, or industry-specific regulations shall be maintained throughout the project duration.</p>',
        'sort_order' => 2,
        'default_required' => 0
    ],
    [
        'title' => 'Audit Requirements',
        'category' => 'compliance',
        'content_html' => '<h3>Audit Requirements</h3><p>The Service Provider shall maintain accurate records of all work performed and make these records available for audit upon reasonable notice.</p><p>The Client shall have the right to audit the Service Provider\'s performance and compliance with the terms of this agreement, provided such audits do not unreasonably interfere with normal business operations.</p>',
        'sort_order' => 3,
        'default_required' => 0
    ],

    // Warranty Modules
    [
        'title' => 'Product Warranty',
        'category' => 'warranty',
        'content_html' => '<h3>Product Warranty</h3><p>All deliverables shall be free from material defects for a period of 90 days following acceptance. The Service Provider shall correct any defects identified during this warranty period at no additional cost.</p><p>This warranty does not cover defects resulting from unauthorized modifications, misuse, or failure to follow provided documentation.</p>',
        'sort_order' => 1,
        'default_required' => 1
    ],
    [
        'title' => 'Service Level Agreement',
        'category' => 'warranty',
        'content_html' => '<h3>Service Level Agreement</h3><p>The Service Provider shall maintain service availability of 99% during normal business hours, excluding scheduled maintenance periods.</p><p>In the event of service level failures, the Service Provider shall provide service credits or other remedies as specified in the service level schedule.</p>',
        'sort_order' => 2,
        'default_required' => 0
    ]
];

try {
    $pdo = getPDO();
    
    // Clear existing modules
    $pdo->exec('DELETE FROM contract_modules');
    
    // Insert new modules
    foreach ($modules as $module) {
        ContractModule::create($module);
        echo "Created module: {$module['title']} ({$module['category']})\n";
    }
    
    echo "\nContract modules populated successfully!\n";
    echo "Total modules created: " . count($modules) . "\n";
    
} catch (Exception $e) {
    echo "Error populating modules: " . $e->getMessage() . "\n";
    exit(1);
}
