<?php

declare(strict_types=1);

require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/ContractModule.php';

echo "Creating signature module for contracts...\n";

$signatureModule = [
    'title' => 'Signature Block',
    'category' => 'signature',
    'content_html' => '<div class="signature-section">
    <h3>Signatures</h3>
    <p>This contract is binding upon signature by both parties.</p>
    
    <div style="display: flex; justify-content: space-between; margin-top: 40px;">
        <div style="width: 45%; text-align: center;">
            <h4>Client Signature</h4>
            <div class="signature-box" style="border: 2px solid #333; height: 80px; margin: 10px 0;">
                <!-- Signature will be captured here -->
            </div>
            <p style="font-size: 12px;">_________________________</p>
            <p style="font-size: 11px; color: #666;">Signature</p>
            <p style="margin-top: 20px; font-size: 11px;">_________________________</p>
            <p style="font-size: 11px; color: #666;">Printed Name</p>
            <p style="margin-top: 20px; font-size: 11px;">_________________________</p>
            <p style="font-size: 11px; color: #666;">Date</p>
        </div>
        
        <div style="width: 45%; text-align: center;">
            <h4>Company Representative</h4>
            <div class="signature-box" style="border: 2px solid #333; height: 80px; margin: 10px 0;">
                <!-- Signature will be captured here -->
            </div>
            <p style="font-size: 12px;">_________________________</p>
            <p style="font-size: 11px; color: #666;">Signature</p>
            <p style="margin-top: 20px; font-size: 11px;">_________________________</p>
            <p style="font-size: 11px; color: #666;">Printed Name</p>
            <p style="margin-top: 20px; font-size: 11px;">_________________________</p>
            <p style="font-size: 11px; color: #666;">Date</p>
        </div>
    </div>
    
    <div style="margin-top: 40px; padding: 20px; background: #f5f5f5; border: 1px solid #ddd;">
        <h4>Witness Information (Optional)</h4>
        <p style="font-size: 11px;">Witness Name: _________________________ Signature: _________________________ Date: _________________________</p>
    </div>
</div>',
    'sort_order' => 999,
    'default_required' => 1
];

try {
    ContractModule::create($signatureModule);
    echo "Signature module created successfully!\n";
} catch (Exception $e) {
    echo "Error creating signature module: " . $e->getMessage() . "\n";
}
