<?php

declare(strict_types=1);

require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/ContractModule.php';

echo "Populating comprehensive legal contract modules...\n";

$legalModules = [
    // Core Legal Terms
    [
        'title' => 'Terms & Conditions',
        'category' => 'legal',
        'content_html' => '<h3>Terms & Conditions</h3><p>This agreement ("Agreement") is entered into as of the Effective Date between the parties identified herein. This Agreement governs the provision of services and related obligations.</p><p><strong>Governing Law:</strong> This Agreement shall be governed by and construed in accordance with the laws of the jurisdiction specified, without regard to its conflict of law principles.</p><p><strong>Entire Agreement:</strong> This Agreement constitutes the entire understanding between the parties and supersedes all prior discussions, negotiations, and agreements, whether oral or written.</p><p><strong>Amendments:</strong> No modification, amendment, or waiver of any provision of this Agreement shall be effective unless in writing and signed by both parties.</p>',
        'sort_order' => 1,
        'default_required' => 1
    ],
    [
        'title' => 'Payment Terms & Invoicing',
        'category' => 'legal',
        'content_html' => '<h3>Payment Terms & Invoicing</h3><p><strong>Payment Schedule:</strong> Payments shall be made according to the schedule outlined in the project scope. All invoices are due within thirty (30) days of receipt.</p><p><strong>Late Payments:</strong> Late payments shall incur interest at a rate of 1.5% per month on the outstanding balance, calculated from the due date until payment is received in full.</p><p><strong>Payment Method:</strong> Payments shall be made via bank transfer, check, or other methods as agreed by both parties. The Client shall be responsible for all bank fees, taxes, and other charges associated with payment processing.</p><p><strong>Deposits:</strong> A non-refundable deposit may be required as specified in the project scope. This deposit shall be applied to the final invoice.</p><p><strong>Disputed Invoices:</strong> If the Client disputes any portion of an invoice, the undisputed portion shall be paid promptly, and the disputed portion shall be resolved in good faith.</p>',
        'sort_order' => 2,
        'default_required' => 1
    ],
    [
        'title' => 'Confidentiality & Non-Disclosure',
        'category' => 'legal',
        'content_html' => '<h3>Confidentiality & Non-Disclosure</h3><p><strong>Definition of Confidential Information:</strong> "Confidential Information" includes all proprietary information, trade secrets, business plans, financial information, customer lists, technical data, product information, and any other information disclosed by either party that is marked as confidential or should reasonably be understood to be confidential.</p><p><strong>Obligations:</strong> Both parties agree to maintain the confidentiality of all Confidential Information received from the other party and to take all reasonable precautions to protect such information from unauthorized disclosure.</p><p><strong>Permitted Disclosure:</strong> Confidential Information may be disclosed only to employees with a need to know and who have signed appropriate confidentiality agreements.</p><p><strong>Duration:</strong> These confidentiality obligations shall survive the termination of this Agreement for a period of five (5) years.</p><p><strong>Return of Information:</strong> Upon termination of this Agreement, all Confidential Information shall be returned or destroyed upon request.</p>',
        'sort_order' => 3,
        'default_required' => 1
    ],
    [
        'title' => 'Intellectual Property Rights',
        'category' => 'legal',
        'content_html' => '<h3>Intellectual Property Rights</h3><p><strong>Ownership of Deliverables:</strong> Upon full payment, all rights, title, and interest in and to the deliverables created under this Agreement shall transfer to the Client, except as otherwise specified herein.</p><p><strong>Pre-existing IP:</strong> Each party retains all rights in their pre-existing intellectual property. Pre-existing IP licensed to the other party under this Agreement remains the property of the licensor.</p><p><strong>Background Technology:</strong> The Service Provider retains all rights in any tools, methodologies, processes, or other intellectual property developed prior to or independent of this Agreement.</p><p><strong>Client Materials:</strong> The Client grants the Service Provider a limited, non-exclusive license to use any materials provided by the Client solely for the purpose of performing services under this Agreement.</p><p><strong>Moral Rights:</strong> To the extent permitted by law, the Client waives any moral rights in the deliverables.</p>',
        'sort_order' => 4,
        'default_required' => 0
    ],
    [
        'title' => 'Limitation of Liability & Indemnification',
        'category' => 'legal',
        'content_html' => '<h3>Limitation of Liability & Indemnification</h3><p><strong>Limitation of Liability:</strong> Neither party shall be liable for any indirect, consequential, special, incidental, or punitive damages arising from this Agreement, including but not limited to lost profits, lost data, or business interruption.</p><p><strong>Direct Damages Cap:</strong> The total liability of either party for direct damages arising from this Agreement shall not exceed the total value of the contract.</p><p><strong>Indemnification:</strong> Each party agrees to indemnify and hold harmless the other party from any claims, damages, or expenses arising from their breach of this Agreement or violation of applicable laws.</p><p><strong>Insurance:</strong> Both parties shall maintain appropriate insurance coverage for their respective business operations, including general liability and professional liability insurance.</p><p><strong>Claims Procedure:</strong> Any claim for indemnification must be made in writing within thirty (30) days of the claim arising.</p>',
        'sort_order' => 5,
        'default_required' => 1
    ],
    [
        'title' => 'Termination & Cancellation',
        'category' => 'legal',
        'content_html' => '<h3>Termination & Cancellation</h3><p><strong>Termination for Cause:</strong> Either party may terminate this Agreement immediately upon written notice if the other party materially breaches any provision and fails to cure such breach within thirty (30) days of written notice.</p><p><strong>Termination for Convenience:</strong> Either party may terminate this Agreement with thirty (30) days written notice to the other party.</p><p><strong>Effect of Termination:</strong> Upon termination, the Client shall pay for all work completed up to the termination date. All licenses granted shall continue as specified.</p><p><strong>Survival:</strong> Sections relating to confidentiality, intellectual property, liability, and payment shall survive termination of this Agreement.</p><p><strong>Return of Materials:</strong> Upon termination, all materials, documents, and other property shall be returned to the owning party.</p><p><strong>Cancellation Fees:</strong> If the Client cancels the project after work has commenced, the Client shall be responsible for all costs incurred plus a reasonable cancellation fee as specified in the project scope.</p>',
        'sort_order' => 6,
        'default_required' => 1
    ],
    [
        'title' => 'Dispute Resolution & Arbitration',
        'category' => 'legal',
        'content_html' => '<h3>Dispute Resolution & Arbitration</h3><p><strong>Negotiation:</strong> Any dispute arising from this Agreement shall first be addressed through good faith negotiations between senior executives of both parties.</p><p><strong>Mediation:</strong> If disputes cannot be resolved through negotiation within thirty (30) days, the parties agree to attempt mediation through a mutually agreed-upon mediator.</p><p><strong>Arbitration:</strong> If mediation fails, disputes shall be resolved through binding arbitration in accordance with the rules of the American Arbitration Association.</p><p><strong>Arbitration Location:</strong> Arbitration shall be conducted in the jurisdiction specified in this Agreement, unless otherwise agreed by both parties.</p><p><strong>Arbitrator Selection:</strong> The arbitrator shall be selected jointly by both parties. If they cannot agree, the arbitrator shall be appointed by the American Arbitration Association.</p><p><strong>Arbitration Costs:</strong> Each party shall bear their own costs of arbitration, and the costs of the arbitrator shall be shared equally.</p><p><strong>Final and Binding:</strong> The decision of the arbitrator shall be final and binding on both parties and may be entered in any court having jurisdiction.</p>',
        'sort_order' => 7,
        'default_required' => 0
    ],
    
    // Service & Delivery Terms
    [
        'title' => 'Scope of Services',
        'category' => 'operational',
        'content_html' => '<h3>Scope of Services</h3><p><strong>Services Description:</strong> The Service Provider shall provide the services as detailed in the project scope or statement of work attached hereto as Exhibit A.</p><p><strong>Performance Standards:</strong> All services shall be performed in a professional and workmanlike manner, in accordance with industry standards and best practices.</p><p><strong>Change Requests:</strong> Any changes to the scope of services must be requested in writing and approved by both parties. Changes may result in adjustments to timeline and compensation.</p><p><strong>Dependencies:</strong> The Service Provider\'s performance is dependent upon timely receipt of required information, materials, and approvals from the Client.</p><p><strong>Third-Party Services:</strong> If third-party services are required, the Service Provider shall obtain client approval before engaging such services.</p>',
        'sort_order' => 1,
        'default_required' => 1
    ],
    [
        'title' => 'Delivery Schedule & Milestones',
        'category' => 'operational',
        'content_html' => '<h3>Delivery Schedule & Milestones</h3><p><strong>Timeline:</strong> Deliverables shall be provided according to the timeline outlined in the project scope. Key milestones and delivery dates are specified in Exhibit B.</p><p><strong>Progress Reports:</strong> The Service Provider shall provide regular progress reports to the Client, including status updates, issues, and upcoming milestones.</p><p><strong>Delays:</strong> The Service Provider shall notify the Client promptly of any anticipated delays. Delays caused by factors beyond the Service Provider\'s control shall result in reasonable extensions of time.</p><p><strong>Client Responsibilities:</strong> The Client shall provide timely feedback, approvals, and required information to ensure project milestones are met.</p><p><strong>Acceptance Period:</strong> The Client shall review deliverables within five (5) business days and provide either acceptance or specific feedback for revisions.</p>',
        'sort_order' => 2,
        'default_required' => 1
    ],
    [
        'title' => 'Acceptance Criteria & Testing',
        'category' => 'operational',
        'content_html' => '<h3>Acceptance Criteria & Testing</h3><p><strong>Acceptance Standards:</strong> Deliverables shall be considered accepted when they meet the specifications outlined in the project scope and pass all quality assurance tests.</p><p><strong>Testing Process:</strong> The Service Provider shall conduct comprehensive testing of all deliverables prior to submission. The Client may conduct additional testing as appropriate.</p><p><strong>Bug Fixes:</strong> The Service Provider shall correct any defects or issues identified during the testing phase at no additional cost.</p><p><strong>Acceptance Procedure:</strong> The Client shall provide written acceptance or specific rejection criteria within the specified review period.</p><p><strong>Deemed Acceptance:</strong> Failure to provide acceptance or rejection criteria within the specified review period shall constitute deemed acceptance.</p><p><strong>Final Acceptance:</strong> Final acceptance shall be confirmed in writing and shall constitute acknowledgment that all deliverables meet the agreed-upon specifications.</p>',
        'sort_order' => 3,
        'default_required' => 1
    ],
    [
        'title' => 'Support & Maintenance',
        'category' => 'operational',
        'content_html' => '<h3>Support & Maintenance</h3><p><strong>Warranty Period:</strong> The Service Provider warrants that deliverables shall be free from material defects for a period of ninety (90) days following final acceptance.</p><p><strong>Technical Support:</strong> During the warranty period, the Service Provider shall provide technical support for issues arising from defects in the deliverables.</p><p><strong>Support Hours:</strong> Technical support shall be available during normal business hours (9:00 AM - 5:00 PM, Monday-Friday, excluding holidays).</p><p><strong>Response Times:</strong> Critical issues shall be addressed within 24 hours, non-critical issues within 3 business days.</p><p><strong>Extended Maintenance:</strong> Extended maintenance agreements may be negotiated separately and shall include ongoing updates, security patches, and technical support.</p><p><strong>Maintenance Scope:</strong> Extended maintenance shall cover bug fixes, security updates, and minor enhancements as specified in the maintenance agreement.</p>',
        'sort_order' => 4,
        'default_required' => 0
    ],
    
    // Compliance & Regulatory
    [
        'title' => 'Data Protection & Privacy',
        'category' => 'compliance',
        'content_html' => '<h3>Data Protection & Privacy</h3><p><strong>Compliance:</strong> Both parties shall comply with all applicable data protection laws, including GDPR, CCPA, and other relevant regulations.</p><p><strong>Data Processing:</strong> Personal data shall be processed only for the purposes specified in this Agreement and in accordance with applicable data protection laws.</p><p><strong>Security Measures:</strong> Appropriate technical and organizational measures shall be implemented to ensure the security of personal data, including encryption, access controls, and regular security audits.</p><p><strong>Data Breach Notification:</strong> Any data breach shall be reported to the affected party within 72 hours of discovery, with details of the breach and remediation measures taken.</p><p><strong>Data Subject Rights:</strong> Both parties shall assist each other in responding to data subject requests, including access, correction, and deletion requests.</p><p><strong>International Transfers:</strong> Any international data transfers shall be conducted in compliance with applicable data protection regulations.</p>',
        'sort_order' => 1,
        'default_required' => 1
    ],
    [
        'title' => 'Industry Compliance & Standards',
        'category' => 'compliance',
        'content_html' => '<h3>Industry Compliance & Standards</h3><p><strong>Regulatory Compliance:</strong> All deliverables shall comply with industry standards and regulations applicable to the Client\'s business sector.</p><p><strong>Certifications:</strong> The Service Provider shall maintain all necessary certifications and licenses required to perform the services.</p><p><strong>Industry Standards:</strong> Work shall be performed in accordance with relevant industry standards, including ISO standards, SOC 2, or other applicable frameworks.</p><p><strong>Regulatory Changes:</strong> Both parties shall notify each other of any regulatory changes that may affect the services or deliverables.</p><p><strong>Audit Rights:</strong> The Client shall have the right to audit the Service Provider\'s compliance with applicable regulations and standards.</p><p><strong>Documentation:</strong> All compliance documentation, including certifications and audit reports, shall be made available to the Client upon request.</p>',
        'sort_order' => 2,
        'default_required' => 0
    ],
    
    // Warranty & Guarantees
    [
        'title' => 'Product Warranty & Guarantees',
        'category' => 'warranty',
        'content_html' => '<h3>Product Warranty & Guarantees</h3><p><strong>Warranty Period:</strong> All deliverables shall be free from material defects and conform to specifications for a period of ninety (90) days following final acceptance.</p><p><strong>Warranty Coverage:</strong> The warranty covers defects in materials, workmanship, and non-conformance with specifications.</p><p><strong>Warranty Exclusions:</strong> This warranty does not cover defects resulting from unauthorized modifications, misuse, neglect, or failure to follow provided documentation.</p><p><strong>Remedy:</strong> The Service Provider shall, at its option, either repair or replace defective deliverables, or refund the portion of the price attributable to the defect.</p><p><strong>Extended Warranty:</strong> Extended warranty options may be negotiated separately and shall provide additional coverage beyond the standard warranty period.</p>',
        'sort_order' => 1,
        'default_required' => 1
    ],
    [
        'title' => 'Service Level Agreement',
        'category' => 'warranty',
        'content_html' => '<h3>Service Level Agreement</h3><p><strong>Service Availability:</strong> The Service Provider shall maintain service availability of 99.5% during normal business hours, excluding scheduled maintenance periods.</p><p><strong>Response Times:</strong> Critical issues shall receive response within 2 hours, high priority issues within 8 hours, medium priority within 24 hours, and low priority within 3 business days.</p><p><strong>Resolution Times:</strong> Critical issues shall be resolved within 24 hours, high priority within 3 business days, medium priority within 7 business days, and low priority within 15 business days.</p><p><strong>Service Credits:</strong> Failure to meet service level commitments shall result in service credits as specified in the service level schedule.</p><p><strong>Maintenance Windows:</strong> Scheduled maintenance shall be performed during non-business hours when possible, with advance notice to the Client.</p><p><strong>Performance Metrics:</strong> Service performance shall be measured and reported monthly, with detailed metrics available upon request.</p>',
        'sort_order' => 2,
        'default_required' => 0
    ],
    
    // Additional Legal Modules
    [
        'title' => 'Force Majeure',
        'category' => 'legal',
        'content_html' => '<h3>Force Majeure</h3><p><strong>Definition:</strong> Neither party shall be liable for delays or failures in performance due to circumstances beyond their reasonable control, including but not limited to acts of God, war, terrorism, natural disasters, labor disputes, or governmental actions.</p><p><strong>Notification:</strong> The affected party shall notify the other party promptly of any force majeure event and its expected impact on performance.</p><p><strong>Obligations:</strong> During a force majeure event, the affected party shall use reasonable efforts to mitigate the impact and resume performance as soon as practicable.</p><p><strong>Termination Rights:</strong> If a force majeure event continues for more than sixty (60) days, either party may terminate the Agreement upon written notice.</p>',
        'sort_order' => 8,
        'default_required' => 0
    ],
    [
        'title' => 'Assignment & Subcontracting',
        'category' => 'legal',
        'content_html' => '<h3>Assignment & Subcontracting</h3><p><strong>Assignment:</strong> Neither party may assign this Agreement without the prior written consent of the other party, except to a successor in interest in the event of merger, acquisition, or sale of substantially all assets.</p><p><strong>Subcontracting:</strong> The Service Provider may subcontract portions of the work with Client approval, provided that the Service Provider remains responsible for all obligations under this Agreement.</p><p><strong>Approval Process:</strong> Any proposed subcontractor must be approved in writing by the Client, which approval shall not be unreasonably withheld.</p><p><strong>Responsibility:</strong> The Service Provider shall remain fully responsible for all work performed by subcontractors as if performed directly by the Service Provider.</p>',
        'sort_order' => 9,
        'default_required' => 0
    ],
    [
        'title' => 'Notices & Communications',
        'category' => 'legal',
        'content_html' => '<h3>Notices & Communications</h3><p><strong>Notice Method:</strong> All notices required under this Agreement shall be in writing and delivered personally, by certified mail, or by email with read receipt confirmation.</p><p><strong>Notice Addresses:</strong> Notices shall be sent to the addresses specified in this Agreement or to such other addresses as either party may designate in writing.</p><p><strong>Effective Date:</strong> Notices shall be deemed effective upon receipt, except for notices of termination which shall be effective upon sending.</p><p><strong>Electronic Communications:</strong> Routine communications may be conducted via email, provided that such communications are confirmed in writing upon request.</p><p><strong>Language:</strong> All notices and communications shall be in the English language.</p>',
        'sort_order' => 10,
        'default_required' => 0
    ],
    [
        'title' => 'Governing Law & Jurisdiction',
        'category' => 'legal',
        'content_html' => '<h3>Governing Law & Jurisdiction</h3><p><strong>Governing Law:</strong> This Agreement shall be governed by and construed in accordance with the laws of the State of [State], without regard to its conflict of law principles.</p><p><strong>Jurisdiction:</strong> The parties consent to the exclusive jurisdiction of the state and federal courts located in [County], [State] for any disputes arising from this Agreement.</p><p><strong>Venue:</strong> Any legal action or proceeding shall be brought in the appropriate court in [County], [State].</p><p><strong>Waiver of Jury Trial:</strong> Both parties waive any right to a jury trial in any dispute arising from this Agreement.</p><p><strong>Attorney\'s Fees:</strong> In any legal action arising from this Agreement, the prevailing party shall be entitled to recover reasonable attorney\'s fees and costs.</p>',
        'sort_order' => 11,
        'default_required' => 0
    ]
];

try {
    $pdo = getPDO();
    
    // Clear existing modules
    $pdo->exec('DELETE FROM contract_modules');
    
    // Insert new modules
    foreach ($legalModules as $module) {
        ContractModule::create($module);
        echo "Created module: {$module['title']} ({$module['category']})\n";
    }
    
    echo "\nContract modules populated successfully!\n";
    echo "Total modules created: " . count($legalModules) . "\n";
    
} catch (Exception $e) {
    echo "Error populating modules: " . $e->getMessage() . "\n";
    exit(1);
}
