-- Create proposal_labels table for categorizing proposals
CREATE TABLE IF NOT EXISTS proposal_labels (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    proposal_id INTEGER NOT NULL,
    label VARCHAR(100) NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (proposal_id) REFERENCES proposals(id) ON DELETE CASCADE,
    UNIQUE(proposal_id, label)
);

-- Create index for faster filtering
CREATE INDEX IF NOT EXISTS idx_proposal_labels_label ON proposal_labels(label);
CREATE INDEX IF NOT EXISTS idx_proposal_labels_proposal_id ON proposal_labels(proposal_id);
