-- Add status and pdf_path columns to proposals table
ALTER TABLE proposals ADD COLUMN status TEXT DEFAULT 'completed';
ALTER TABLE proposals ADD COLUMN pdf_path TEXT;
ALTER TABLE proposals ADD COLUMN title TEXT;

-- Update existing proposals to have completed status and default titles
UPDATE proposals SET status = 'completed', title = 'Proposal #' || id WHERE title IS NULL OR title = '';

-- Create index for status filtering
CREATE INDEX IF NOT EXISTS idx_proposals_status ON proposals(status);
