<?php
session_start();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Session Debug</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .debug-section { background: #f5f5f5; padding: 15px; margin: 10px 0; border-radius: 5px; }
        pre { background: #fff; padding: 10px; border: 1px solid #ddd; border-radius: 3px; }
    </style>
</head>
<body>
    <h1>Session Debug Information</h1>
    
    <div class="debug-section">
        <h2>Session Data</h2>
        <pre><?php print_r($_SESSION); ?></pre>
    </div>
    
    <div class="debug-section">
        <h2>Current Company</h2>
        <?php
        if (isset($_SESSION['current_company'])) {
            echo '<pre>' . print_r($_SESSION['current_company'], true) . '</pre>';
        } else {
            echo '<p>No current company in session</p>';
        }
        ?>
    </div>
    
    <div class="debug-section">
        <h2>Session Company ID</h2>
        <p><?php echo $_SESSION['current_company_id'] ?? 'Not set'; ?></p>
    </div>
    
    <div class="debug-section">
        <h2>Tenant Manager Data</h2>
        <?php
        require_once __DIR__ . '/../src/db.php';
        require_once __DIR__ . '/../src/Auth/AuthManager.php';
        require_once __DIR__ . '/../src/MultiTenant/TenantManager.php';
        
        if (AuthManager::isAuthenticated()) {
            $user = AuthManager::getCurrentUser();
            $company = TenantManager::getCurrentCompany();
            
            echo '<h3>User:</h3>';
            echo '<pre>' . print_r($user, true) . '</pre>';
            
            echo '<h3>Company:</h3>';
            echo '<pre>' . print_r($company, true) . '</pre>';
        } else {
            echo '<p>Not authenticated</p>';
        }
        ?>
    </div>
    
    <div class="debug-section">
        <h2>All Companies in Database</h2>
        <?php
        $pdo = getPDO();
        $stmt = $pdo->query("SELECT id, name, subdomain FROM companies ORDER BY created_at DESC");
        $companies = $stmt->fetchAll();
        echo '<pre>' . print_r($companies, true) . '</pre>';
        ?>
    </div>
    
    <p><a href="/index.php">← Back to Dashboard</a></p>
</body>
</html>
