<?php
session_start();
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/Auth/AuthManager.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title>Workspace Debug</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .debug-section { background: #f5f5f5; padding: 15px; margin: 10px 0; border-radius: 5px; }
        pre { background: #fff; padding: 10px; border: 1px solid #ddd; border-radius: 3px; }
        .test-btn { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; margin: 5px; }
    </style>
</head>
<body>
    <h1>Workspace Debug Tool</h1>
    
    <div class="debug-section">
        <h2>Current Session Data</h2>
        <pre>Session Company ID: <?php echo $_SESSION['current_company_id'] ?? 'none'; ?></pre>
        <pre>Session Company Name: <?php echo $_SESSION['current_company']['name'] ?? 'none'; ?></pre>
        <pre>Session Company Data: <?php echo json_encode($_SESSION['current_company'] ?? []); ?></pre>
    </div>
    
    <div class="debug-section">
        <h2>Test Workspace Switching</h2>
        <form method="POST" action="/workspace-switch.php">
            <input type="hidden" name="company_id" value="6">
            <button type="submit" class="test-btn">Switch to Axentra (ID: 6)</button>
        </form>
        
        <form method="POST" action="/workspace-switch.php">
            <input type="hidden" name="company_id" value="2">
            <button type="submit" class="test-btn">Switch to Pixelvise2 (ID: 2)</button>
        </form>
        
        <form method="POST" action="/workspace-switch.php">
            <input type="hidden" name="company_id" value="1">
            <button type="submit" class="test-btn">Switch to Default Company (ID: 1)</button>
        </form>
    </div>
    
    <div class="debug-section">
        <h2>All Companies</h2>
        <?php
        $pdo = getPDO();
        $stmt = $pdo->query("SELECT id, name, subdomain FROM companies ORDER BY id");
        $companies = $stmt->fetchAll();
        echo '<pre>' . json_encode($companies, JSON_PRETTY_PRINT) . '</pre>';
        ?>
    </div>
    
    <div class="debug-section">
        <h2>Authentication Status</h2>
        <pre>Authenticated: <?php echo AuthManager::isAuthenticated() ? 'YES' : 'NO'; ?></pre>
        <?php if (AuthManager::isAuthenticated()): ?>
            <pre>User: <?php echo AuthManager::getCurrentUser()['name'] ?? 'Unknown'; ?></pre>
        <?php endif; ?>
    </div>
    
    <p><a href="/index.php">← Back to Dashboard</a></p>
</body>
</html>
