<?php
// Simple debug capture
error_log("DEBUG: Clients page accessed at " . date('Y-m-d H:i:s'));
error_log("DEBUG: GET data: " . json_encode($_GET));
error_log("DEBUG: Workspace parameter: " . ($_GET['workspace'] ?? 'none'));

// Check tenant context
require_once __DIR__ . '/src/TenantDB.php';
$tenantId = TenantDB::getTenant();
error_log("DEBUG: Current tenant ID: " . ($tenantId ?? 'none'));

// Test query directly
require_once __DIR__ . '/src/helpers.php';
require_once __DIR__ . '/src/db.php';
$pdo = getPDO();
$stmt = $pdo->prepare("SELECT * FROM clients WHERE company_id = ? ORDER BY created_at DESC");
$stmt->execute([$tenantId]);
$clients = $stmt->fetchAll();
error_log("DEBUG: Direct query result count: " . count($clients));
?>
