<?php
declare(strict_types=1);
require_once __DIR__ . '/navigation.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Access Denied · Keelance Admin</title>
    <link rel="icon" type="image/png" href="/assets/favicon.png">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="min-h-screen bg-slate-100 font-sans antialiased text-slate-900">
<div class="min-h-screen flex flex-col">
    <?php renderAdminNavigation(); ?>

    <main class="flex-1 flex items-center justify-center px-4 py-12">
        <div class="max-w-md w-full text-center space-y-5">
            <div>
                <p class="text-xs font-semibold tracking-[0.25em] text-slate-400 uppercase mb-2">Admin Panel</p>
                <h1 class="text-4xl font-bold text-slate-900 mb-1">Access denied</h1>
                <p class="text-sm text-slate-500">You don't have permission to view this page in the admin panel.</p>
            </div>

            <div class="rounded-xl border border-amber-200 bg-amber-50 px-5 py-4 text-left space-y-2 inline-block text-start">
                <div class="flex items-center gap-2">
                    <span class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-amber-100 text-amber-700 text-sm font-semibold">403</span>
                    <p class="text-sm font-medium text-amber-900">Insufficient permissions</p>
                </div>
                <p class="text-xs text-amber-800">
                    If you believe this is a mistake, contact a higher-level admin to grant you access.
                </p>
            </div>

            <div class="flex flex-col sm:flex-row gap-3 justify-center mt-2">
                <a href="/admin/index.php" class="inline-flex items-center justify-center rounded-md bg-slate-900 px-4 py-2.5 text-sm font-semibold text-white shadow-sm hover:bg-slate-800">
                    ← Back to Admin Dashboard
                </a>
                <a href="/" class="inline-flex items-center justify-center rounded-md border border-slate-200 bg-white px-4 py-2.5 text-sm font-semibold text-slate-700 hover:bg-slate-50">
                    Go to main site
                </a>
            </div>
        </div>
    </main>

    <?php renderAdminFooter(); ?>
</div>
</body>
</html>
