<?php

declare(strict_types=1);

require_once __DIR__ . '/../../src/db.php';
require_once __DIR__ . '/../../src/SuperAdmin/SuperAdminAuth.php';

$error = '';

// Check if already logged in
if (SuperAdminAuth::getCurrentAdmin()) {
    header('Location: /admin/index.php');
    exit;
}

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($email) || empty($password)) {
        $error = 'Please enter email and password.';
    } else {
        $result = SuperAdminAuth::login($email, $password);
        if ($result['success']) {
            header('Location: /admin/index.php');
            exit;
        } else {
            $error = $result['error'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login · Keelance</title>
    <link rel="icon" type="image/png" href="/assets/favicon.png">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="min-h-screen bg-slate-100 font-sans antialiased">
    <div class="min-h-screen flex flex-col">
        <main class="flex-1 flex items-center justify-center px-4 py-8">
            <div class="w-full max-w-md space-y-6">
                <!-- Logo & Title -->
                <div class="text-center">
                    <div class="flex justify-center mb-2">
                        <img src="/assets/KeelanceLogo.png" alt="Keelance" class="h-10 w-auto">
                    </div>
                    <p class="text-xs font-medium text-slate-500 tracking-wide uppercase">Admin Panel</p>
                </div>

                <!-- Admin Login Card -->
                <div class="border border-slate-200 bg-white text-slate-900 shadow-md rounded-xl p-6 space-y-5">
                    <div class="space-y-1">
                        <h1 class="text-base font-semibold text-slate-900">Sign in to Keelance Admin</h1>
                        <p class="text-xs text-slate-500">Super admin access for users, workspaces, billing, and more.</p>
                    </div>

                    <?php if ($error): ?>
                        <div class="rounded-lg bg-red-50 border border-red-200 p-3 text-sm text-red-700">
                            <?= htmlspecialchars($error) ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST" class="space-y-4">
                        <div class="space-y-2">
                            <label for="email" class="block text-sm font-medium text-slate-700">Email</label>
                            <input type="email" id="email" name="email" required
                                   class="block w-full rounded-md border border-slate-300 bg-white px-3 py-2 text-sm shadow-sm placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                   placeholder="admin@keelance.com"
                                   value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
                        </div>

                        <div class="space-y-2">
                            <label for="password" class="block text-sm font-medium text-slate-700">Password</label>
                            <input type="password" id="password" name="password" required
                                   class="block w-full rounded-md border border-slate-300 bg-white px-3 py-2 text-sm shadow-sm placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                   placeholder="Enter your password">
                        </div>

                        <button type="submit"
                                class="w-full inline-flex items-center justify-center rounded-md bg-blue-600 px-4 py-2.5 text-sm font-semibold text-white shadow-sm hover:bg-blue-700 transition-colors">
                            Sign in
                        </button>
                    </form>
                </div>

                <p class="text-center text-slate-500 text-xs">
                    <a href="/" class="hover:text-slate-700">← Back to Keelance</a>
                </p>
            </div>
        </main>

        <?php include __DIR__ . '/../footer.php'; ?>
    </div>
</body>
</html>
