<?php

declare(strict_types=1);

require_once __DIR__ . '/../../src/SuperAdmin/SuperAdminAuth.php';

function renderAdminNavigation(): void
{
    $admin = SuperAdminAuth::getCurrentAdmin();
    $currentPage = basename($_SERVER['PHP_SELF'], '.php');
    
    $navItems = [
        [
            'type' => 'link',
            'id' => 'index',
            'label' => 'Dashboard',
            'permission' => null,
            'icon' => 'M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6',
        ],
        [
            'type' => 'dropdown',
            'label' => 'People',
            'icon' => 'M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0z',
            'items' => [
                [
                    'id' => 'users',
                    'label' => 'Users',
                    'permission' => 'users_view',
                    'icon' => 'M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0z',
                ],
                [
                    'id' => 'workspaces',
                    'label' => 'Workspaces',
                    'permission' => 'workspaces_view',
                    'icon' => 'M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4',
                ],
            ],
        ],
        [
            'type' => 'dropdown',
            'label' => 'Billing',
            'icon' => 'M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z',
            'items' => [
                [
                    'id' => 'billing',
                    'label' => 'Billing Overview',
                    'permission' => 'billing_view',
                    'icon' => 'M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z',
                ],
                [
                    'id' => 'plans',
                    'label' => 'Plans',
                    'permission' => 'plans_view',
                    'icon' => 'M4 6h16M4 10h16M4 14h16M4 18h16',
                ],
                [
                    'id' => 'discounts',
                    'label' => 'Discounts',
                    'permission' => 'discounts_view',
                    'icon' => 'M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z',
                ],
            ],
        ],
        [
            'type' => 'dropdown',
            'label' => 'System',
            'icon' => 'M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z',
            'items' => [
                [
                    'id' => 'settings',
                    'label' => 'Settings',
                    'permission' => 'settings_view',
                    'icon' => 'M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z',
                ],
                [
                    'id' => 'admins',
                    'label' => 'Admin Staff',
                    'permission' => 'admins_view',
                    'icon' => 'M5.121 17.804A4 4 0 017 11h.25a6.978 6.978 0 013.126-.75h3.248a6.978 6.978 0 013.126.75H17a4 4 0 011.879 6.804M15 7a3 3 0 11-6 0 3 3 0 016 0z',
                ],
                [
                    'id' => 'activity',
                    'label' => 'Activity Log',
                    'permission' => 'activity_log_view',
                    'icon' => 'M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z',
                ],
            ],
        ],
    ];
?>
<header class="bg-white shadow-sm">
    <div class="max-w-6xl mx-auto px-4 py-2">
        <div class="flex items-center h-12">
            <!-- Left: Logo -->
            <div class="flex items-center">
                <a href="/admin/index.php" class="flex items-center hover:opacity-80 transition-opacity">
                    <img src="/assets/KeelanceLogo.png" alt="Keelance" class="h-8 w-auto mr-2">
                    <span class="px-2 py-0.5 text-[10px] font-semibold tracking-wide uppercase rounded-full bg-slate-900 text-white">Admin</span>
                </a>
            </div>

            <!-- Center: Main Nav -->
            <div class="flex-1 flex justify-center">
                <nav class="hidden md:flex items-center space-x-1">
                    <?php foreach ($navItems as $item): ?>
                        <?php if (($item['type'] ?? 'link') === 'link'): ?>
                            <?php if ($item['permission'] === null || SuperAdminAuth::hasPermission($item['permission'])): ?>
                                <a href="/admin/<?= $item['id'] ?>.php"
                                   class="flex items-center px-2.5 py-1.5 rounded text-xs font-medium transition-colors <?= $currentPage === $item['id'] ? 'bg-slate-900 text-white shadow-sm' : 'text-slate-600 hover:text-slate-900 hover:bg-slate-50' ?>">
                                    <?php if (!empty($item['icon'])): ?>
                                        <svg class="w-3.5 h-3.5 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?= $item['icon'] ?>"></path>
                                        </svg>
                                    <?php endif; ?>
                                    <span><?= htmlspecialchars($item['label']) ?></span>
                                </a>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php
                            $visibleChildren = [];
                            foreach ($item['items'] as $child) {
                                if ($child['permission'] === null || SuperAdminAuth::hasPermission($child['permission'])) {
                                    $visibleChildren[] = $child;
                                }
                            }
                            if (empty($visibleChildren)) {
                                continue;
                            }
                            $isActiveDropdown = false;
                            foreach ($visibleChildren as $child) {
                                if ($currentPage === $child['id']) {
                                    $isActiveDropdown = true;
                                    break;
                                }
                            }
                            ?>
                            <div class="relative group">
                                <button class="flex items-center px-2.5 py-1.5 rounded text-xs font-medium transition-colors <?= $isActiveDropdown ? 'bg-slate-900 text-white shadow-sm' : 'text-slate-600 hover:text-slate-900 hover:bg-slate-50' ?>">
                                    <?php if (!empty($item['icon'])): ?>
                                        <svg class="w-3.5 h-3.5 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?= $item['icon'] ?>"></path>
                                        </svg>
                                    <?php endif; ?>
                                    <span><?= htmlspecialchars($item['label']) ?></span>
                                    <svg class="w-3 h-3 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                <div class="absolute left-0 mt-1 w-48 rounded-md shadow-lg bg-white border border-slate-200 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                                    <div class="py-1">
                                        <?php foreach ($visibleChildren as $child): ?>
                                            <a href="/admin/<?= $child['id'] ?>.php" class="flex items-center px-3 py-2 text-xs text-slate-700 hover:bg-slate-50 hover:text-slate-900 transition-colors">
                                                <?php if (!empty($child['icon'])): ?>
                                                    <svg class="w-3.5 h-3.5 mr-2 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?= $child['icon'] ?>"></path>
                                                    </svg>
                                                <?php endif; ?>
                                                <span><?= htmlspecialchars($child['label']) ?></span>
                                            </a>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </nav>
            </div>

            <!-- Right: Profile Dropdown -->
            <div class="ml-3">
                <div class="relative group">
                    <button class="flex items-center gap-1.5 rounded-full px-2 py-1.5 text-xs font-medium text-slate-600 hover:text-slate-900 hover:bg-slate-50 transition-colors">
                        <div class="w-7 h-7 rounded-full bg-blue-100 flex items-center justify-center text-xs font-semibold text-blue-700">
                            <?= strtoupper(substr($admin['name'] ?? 'A', 0, 1)) ?>
                        </div>
                        <svg class="w-3 h-3 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="absolute right-0 mt-1 w-52 rounded-md shadow-lg bg-white border border-slate-200 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                        <div class="py-1">
                            <div class="px-3 py-2 border-b border-slate-100">
                                <p class="text-sm font-medium text-slate-900 truncate"><?= htmlspecialchars($admin['name'] ?? 'Admin') ?></p>
                                <?php if (!empty($admin['role'])): ?>
                                    <p class="text-xs text-slate-500 mt-0.5 capitalize"><?= htmlspecialchars($admin['role']) ?></p>
                                <?php endif; ?>
                            </div>
                            <a href="/admin/logout.php" class="flex items-center px-3 py-2 text-xs text-red-600 hover:bg-red-50 transition-colors">
                                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                                </svg>
                                <span>Logout</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

<!-- Mobile Navigation -->
<div class="md:hidden bg-white border-b border-slate-200">
    <div class="flex overflow-x-auto py-2 px-4 gap-2">
        <?php foreach ($navItems as $item): ?>
            <?php if (($item['type'] ?? 'link') === 'link'): ?>
                <?php if ($item['permission'] === null || SuperAdminAuth::hasPermission($item['permission'])): ?>
                    <a href="/admin/<?= $item['id'] ?>.php"
                       class="flex-shrink-0 flex items-center px-2.5 py-1.5 rounded text-xs font-medium transition-colors <?= $currentPage === $item['id'] ? 'bg-slate-900 text-white shadow-sm' : 'text-slate-600 hover:text-slate-900 hover:bg-slate-50' ?>">
                        <?php if (!empty($item['icon'])): ?>
                            <svg class="w-3.5 h-3.5 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?= $item['icon'] ?>"></path>
                            </svg>
                        <?php endif; ?>
                        <span><?= htmlspecialchars($item['label']) ?></span>
                    </a>
                <?php endif; ?>
            <?php else: ?>
                <?php
                $visibleChildren = [];
                foreach ($item['items'] as $child) {
                    if ($child['permission'] === null || SuperAdminAuth::hasPermission($child['permission'])) {
                        $visibleChildren[] = $child;
                    }
                }
                foreach ($visibleChildren as $child) {
                    $isActiveChild = ($currentPage === $child['id']);
                    ?>
                    <a href="/admin/<?= $child['id'] ?>.php"
                       class="flex-shrink-0 flex items-center px-2.5 py-1.5 rounded text-xs font-medium transition-colors <?= $isActiveChild ? 'bg-slate-900 text-white shadow-sm' : 'text-slate-600 hover:text-slate-900 hover:bg-slate-50' ?>">
                        <?php if (!empty($child['icon'])): ?>
                            <svg class="w-3.5 h-3.5 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?= $child['icon'] ?>"></path>
                            </svg>
                        <?php endif; ?>
                        <span><?= htmlspecialchars($child['label']) ?></span>
                    </a>
                <?php }
                ?>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
</div>
<?php
}

function renderAdminFooter(): void
{
?>
<footer class="border-t border-slate-200/80 bg-white/80 backdrop-blur supports-[backdrop-filter]:bg-white/60 mt-auto">
    <div class="max-w-6xl mx-auto px-4 py-6">
        <div class="flex flex-col items-center gap-3 footer-fade-up">
            <div class="flex items-center gap-2">
                <img src="/assets/KeelanceLogo.png" alt="Keelance" class="h-5 w-auto">
                <span class="px-2 py-0.5 text-[10px] font-semibold tracking-wide uppercase rounded-full bg-slate-900 text-white">Admin</span>
            </div>
            <p class="text-xs text-slate-500">
                &copy; <?= date('Y') ?> Keelance. All rights reserved.
            </p>
        </div>
    </div>
    <style>
        @keyframes footer-fade-up {
            0% {
                opacity: 0;
                transform: translateY(6px);
            }
            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .footer-fade-up {
            animation: footer-fade-up 0.45s ease-out;
        }
    </style>
</footer>
<?php
}
