<?php
/**
 * Permission Denied Banner Component
 * 
 * Displays a centered message when user lacks permissions
 * 
 * @param string $title Main heading
 * @param string $message Description message
 * @param string|null $workspaceName Optional workspace name to include
 * @param string|null $backUrl Optional back button URL
 * @param string|null $backLabel Optional back button label
 */

function renderPermissionBanner(
    string $title, 
    string $message, 
    ?string $workspaceName = null,
    ?string $backUrl = null,
    ?string $backLabel = 'Back to Dashboard'
): void {
?>
<section class="dashboard-card">
    <div class="p-6 sm:p-8 text-center">
        <div class="mx-auto mb-4 flex h-12 w-12 items-center justify-center rounded-full bg-amber-500/10">
            <svg class="h-6 w-6 text-amber-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
            </svg>
        </div>
        <div class="space-y-2">
            <h2 class="text-sm font-semibold text-neutral-50"><?= htmlspecialchars($title) ?></h2>
            <p class="text-xs text-neutral-400 max-w-md mx-auto">
                <?= htmlspecialchars($message) ?>
                <?php if ($workspaceName): ?>
                    <strong class="text-neutral-50"><?= htmlspecialchars($workspaceName) ?></strong>
                <?php endif; ?>
            </p>
            <p class="text-[11px] text-neutral-500">Contact the workspace owner if you need to make changes.</p>
        </div>
        <?php if ($backUrl): ?>
            <a href="<?= htmlspecialchars($backUrl) ?>" 
               class="mt-6 inline-flex items-center gap-1 rounded-md border border-neutral-700 bg-neutral-900 px-4 py-2 text-xs font-semibold text-neutral-100 hover:bg-neutral-800 transition">
                <?= htmlspecialchars($backLabel) ?>
            </a>
        <?php endif; ?>
    </div>
</section>
<?php
}
