<?php
/**
 * Status Banner Component
 * 
 * Displays success, error, warning, or info banners
 * 
 * @param string $type Banner type: 'success', 'error', 'warning', 'info'
 * @param string $message Message to display
 * @param array $details Optional array of detail messages for errors
 */

function renderStatusBanner(string $type, string $message, array $details = []): void {
    $icons = [
        'success' => 'M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z',
        'error' => 'M10 18a8 8 0 100-16 8 8 0 000 16zm-.75-11.5a.75.75 0 011.5 0v5a.75.75 0 01-1.5 0v-5zm.75 8a1 1 0 100-2 1 1 0 000 2z',
        'warning' => 'M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z',
        'info' => 'M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z',
    ];
?>
<div class="status-banner <?= htmlspecialchars($type) ?>">
    <svg class="w-4 h-4 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="<?= $icons[$type] ?? $icons['info'] ?>" clip-rule="evenodd"></path>
    </svg>
    <?php if (empty($details)): ?>
        <span><?= htmlspecialchars($message) ?></span>
    <?php else: ?>
        <div>
            <span class="font-medium"><?= htmlspecialchars($message) ?></span>
            <ul class="list-disc list-inside space-y-1 mt-1 text-sm">
                <?php foreach ($details as $detail): ?>
                    <li><?= htmlspecialchars($detail) ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>
</div>
<?php
}
