<?php
/**
 * Simple Page Header Component (Profile/Settings style)
 * 
 * Displays a sticky header with simple breadcrumbs (no workspace context)
 * 
 * @param array $breadcrumbs Array of breadcrumb items [['label' => 'Account', 'icon' => 'svg_path'], ...]
 * @param string $currentPage Current page title
 * @param array $actions Array of action buttons
 * @param string|null $workspaceQuery Workspace query string
 */

function renderSimplePageHeader(array $breadcrumbs, string $currentPage, array $actions = [], ?string $workspaceQuery = ''): void {
?>
<header class="sticky top-0 z-30 flex items-center justify-between px-3 md:px-6 h-12 border-b border-neutral-800 bg-neutral-950/95 backdrop-blur supports-[backdrop-filter]:backdrop-blur-md">
    <div class="flex items-center gap-3 text-sm text-neutral-400">
        <!-- Mobile Menu Button -->
        <button id="mobile-menu-btn" class="md:hidden inline-flex items-center justify-center p-2 rounded-lg hover:text-neutral-100 hover:bg-neutral-800 transition">
            <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
            </svg>
        </button>
        
        <!-- Simple Breadcrumbs -->
        <nav class="flex items-center gap-2 text-xs">
            <?php foreach ($breadcrumbs as $crumb): ?>
                <span class="inline-flex items-center gap-1 text-[#A1A1A1]">
                    <?php if (!empty($crumb['icon'])): ?>
                        <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?= $crumb['icon'] ?>"></path>
                        </svg>
                    <?php endif; ?>
                    <?= htmlspecialchars($crumb['label']) ?>
                </span>
                <svg class="h-3 w-3 text-neutral-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            <?php endforeach; ?>
            <span class="text-neutral-50 font-semibold truncate max-w-[140px] md:max-w-xs"><?= htmlspecialchars($currentPage) ?></span>
        </nav>
    </div>
    
    <!-- Action Buttons -->
    <div class="flex items-center gap-2 text-xs">
        <?php foreach ($actions as $action): ?>
            <?php 
                $buttonClass = ($action['type'] ?? 'secondary') === 'primary' ? 'btn-emerald' : 'btn-secondary';
            ?>
            <a href="<?= htmlspecialchars($action['url'] . $workspaceQuery) ?>" class="<?= $buttonClass ?> inline-flex items-center gap-1 px-3 py-1">
                <?php if (!empty($action['icon'])): ?>
                    <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?= $action['icon'] ?>"></path>
                    </svg>
                <?php endif; ?>
                <?= htmlspecialchars($action['label']) ?>
            </a>
        <?php endforeach; ?>
    </div>
</header>
<?php
}
