<?php
/**
 * Page Hero with Stats Component (Templates/Modules style)
 * 
 * Displays hero with stat chips on the right
 * 
 * @param string $label Small uppercase label
 * @param string $title Main heading
 * @param string $description Subtitle
 * @param array $stats Array of stat chips [['label' => 'Total', 'value' => '24', 'type' => 'primary|neutral'], ...]
 */

function renderPageHeroWithStats(string $label, string $title, string $description, array $stats = []): void {
?>
<section class="dashboard-card overflow-hidden">
    <div class="bg-gradient-to-r from-emerald-500/10 via-transparent to-transparent px-6 py-6 space-y-4">
        <p class="text-[11px] uppercase tracking-[0.35em] text-neutral-500"><?= htmlspecialchars($label) ?></p>
        <div class="flex flex-col gap-5 md:flex-row md:items-center md:justify-between">
            <div class="space-y-2 max-w-2xl">
                <h2 class="text-lg font-semibold text-neutral-50"><?= htmlspecialchars($title) ?></h2>
                <p class="text-xs text-neutral-400"><?= htmlspecialchars($description) ?></p>
            </div>
            <?php if (!empty($stats)): ?>
                <div class="grid grid-cols-1 gap-2 text-xs">
                    <?php foreach ($stats as $stat): ?>
                        <?php 
                            $chipClass = ($stat['type'] ?? 'neutral') === 'primary' 
                                ? 'border-emerald-500/30 bg-emerald-500/10 text-emerald-200' 
                                : 'border-neutral-800 bg-neutral-900/60';
                        ?>
                        <div class="hero-chip inline-flex items-center gap-2 rounded-full border <?= $chipClass ?> px-3 py-1">
                            <span class="text-[10px] uppercase tracking-[0.2em] text-neutral-500"><?= htmlspecialchars($stat['label']) ?></span>
                            <span class="font-semibold text-neutral-50"><?= htmlspecialchars($stat['value']) ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php
}
