<?php
/**
 * Standard Page Hero Component
 * 
 * Displays a hero section with label, title, and description
 * 
 * @param string $label Small uppercase label (e.g., "DASHBOARD", "WORKSPACE")
 * @param string $title Main heading
 * @param string $description Subtitle/description text
 * @param array $extras Optional extra content (chips, badges, etc.) - array of HTML strings
 */

function renderPageHero(string $label, string $title, string $description, array $extras = []): void {
?>
<section class="dashboard-card overflow-hidden">
    <div class="bg-gradient-to-r from-emerald-500/10 via-transparent to-transparent px-6 py-6 space-y-4">
        <p class="text-[11px] uppercase tracking-[0.35em] text-neutral-500"><?= htmlspecialchars($label) ?></p>
        <div class="flex flex-col gap-4 md:flex-row md:items-center md:justify-between">
            <div class="space-y-1 max-w-2xl">
                <h1 class="text-lg font-semibold text-neutral-50"><?= htmlspecialchars($title) ?></h1>
                <p class="text-xs text-neutral-400"><?= htmlspecialchars($description) ?></p>
            </div>
            <?php if (!empty($extras)): ?>
                <div class="flex flex-wrap items-center gap-2">
                    <?php foreach ($extras as $extra): ?>
                        <?= $extra ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php
}
