<?php
/**
 * Design System - Living Style Guide
 * All styles use CSS variables for proper light/dark mode support
 */
require_once __DIR__ . '/../src/helpers.php';
require_once __DIR__ . '/../src/Auth/AuthManager.php';
require_once __DIR__ . '/../src/MultiTenant/TenantManager.php';
require_once __DIR__ . '/components/banners/status-banner.php';
require_once __DIR__ . '/components/headers/page-header.php';
require_once __DIR__ . '/components/hero/page-hero.php';
require_once __DIR__ . '/components/hero/page-hero-stats.php';

$workspaceQuery = '?workspace=demo';
$currentTheme = $_GET['theme'] ?? (AuthManager::isAuthenticated() ? ($_SESSION['theme_preference'] ?? 'dark') : 'dark');
$currentTheme = in_array($currentTheme, ['dark', 'light'], true) ? $currentTheme : 'dark';
?>
<!DOCTYPE html>
<html lang="en" data-theme="<?= htmlspecialchars($currentTheme) ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Design System · Keelance</title>
    <link rel="stylesheet" href="/assets/styles/app.build.css">
    <script>
        // Initialize theme BEFORE page renders to prevent flash
        (function() {
            var saved = localStorage.getItem('theme') || '<?= $currentTheme ?>';
            document.documentElement.setAttribute('data-theme', saved);
        })();
    </script>
    <style>
        :root {
            --page-bg: #0f0f0f;
            --surface-card: rgba(255,255,255,0.03);
            --surface-base: rgba(255,255,255,0.02);
            --surface-muted: rgba(255,255,255,0.05);
            --surface-border: rgba(255,255,255,0.08);
            --border-subtle: rgba(255,255,255,0.06);
            --border-strong: rgba(255,255,255,0.12);
            --text-primary: rgba(255,255,255,0.92);
            --text-secondary: rgba(255,255,255,0.7);
            --text-muted: rgba(255,255,255,0.55);
            --text-tertiary: rgba(255,255,255,0.4);
            --text-faint: rgba(255,255,255,0.3);
            --accent: #10b981;
            --accent-muted: rgba(16,185,129,0.15);
            --chip-active-bg: rgba(16,185,129,0.15);
            --chip-active-color: #34d399;
            --chip-inactive-bg: rgba(255,255,255,0.08);
            --chip-inactive-color: rgba(255,255,255,0.7);
            --danger: #ef4444;
        }

        [data-theme='light'] {
            --page-bg: #f5f5f4;
            --surface-card: #fff;
            --surface-base: #fafafa;
            --surface-muted: #f4f4f3;
            --surface-border: rgba(0,0,0,0.08);
            --border-subtle: rgba(0,0,0,0.06);
            --border-strong: rgba(0,0,0,0.12);
            --text-primary: #37352f;
            --text-secondary: rgba(55,53,47,0.75);
            --text-muted: rgba(55,53,47,0.55);
            --text-tertiary: rgba(55,53,47,0.45);
            --text-faint: rgba(55,53,47,0.35);
            --accent: #2563eb;
            --accent-muted: rgba(37,99,235,0.12);
            --chip-active-bg: rgba(37,99,235,0.12);
            --chip-active-color: #2563eb;
            --chip-inactive-bg: rgba(55,53,47,0.08);
            --chip-inactive-color: rgba(55,53,47,0.65);
            --danger: #b91c1c;
        }

        * { transition: background-color 0.2s ease, color 0.2s ease, border-color 0.2s ease; }
        .ds-section { margin-bottom: 3rem; }
        .ds-title { font-size: 1.5rem; font-weight: 700; color: var(--text-primary); margin-bottom: 1rem; }
        .ds-subtitle { font-size: 1rem; font-weight: 600; color: var(--text-primary); margin-bottom: 0.75rem; }
        .ds-text { color: var(--text-muted); font-size: 0.875rem; }
        .ds-code { background: var(--surface-base); border: 1px solid var(--surface-border); border-radius: 8px; padding: 1rem; font-family: monospace; font-size: 0.75rem; color: var(--text-primary); overflow-x: auto; }
        .ds-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; }
        .ds-swatch { height: 60px; border-radius: 8px; border: 1px solid var(--surface-border); display: flex; align-items: flex-end; padding: 0.5rem; font-size: 0.625rem; color: var(--text-primary); }

        .dashboard-card { background: var(--surface-card); border: 1px solid var(--surface-border); border-radius: 8px; }
        .stat-card,
        .metric-card,
        .action-card { border-radius: 8px; border: 1px solid var(--surface-border); background: var(--surface-card); padding: 1rem; }
        .stat-value { color: var(--text-primary); }
        .stat-label { color: var(--text-muted); font-size: 0.75rem; }

        .btn-emerald { background: #37352f; color: #fff; border: none; border-radius: 4px; padding: 0.5rem 1rem; font-size: 0.875rem; cursor: pointer; }
        .btn-emerald:hover { background: #2f2e2b; }
        .btn-secondary { background: transparent; border: 1px solid var(--border-subtle); color: var(--text-secondary); border-radius: 4px; padding: 0.5rem 1rem; }
        .btn-secondary:hover { background: var(--surface-muted); color: var(--text-primary); }
        .btn-danger { background: transparent; border: 1px solid rgba(235,87,87,0.3); color: var(--danger); border-radius: 4px; padding: 0.5rem 1rem; }
        .btn-danger:hover { background: rgba(235,87,87,0.1); }
        .btn-icon { background: var(--surface-muted); border: 1px solid var(--surface-border); color: var(--text-primary); border-radius: 4px; padding: 0.5rem; display: inline-flex; align-items: center; justify-content: center; }

        .form-label { font-size: 0.75rem; font-weight: 500; color: var(--text-secondary); margin-bottom: 0.35rem; display: inline-block; }
        .form-input,
        .form-select,
        .form-textarea { width: 100%; border-radius: 6px; border: 1px solid var(--border-subtle); background: var(--surface-base); color: var(--text-primary); padding: 0.5rem 0.75rem; font-size: 0.875rem; }
        .form-input:focus,
        .form-select:focus,
        .form-textarea:focus { outline: none; border-color: var(--border-strong); background: var(--surface-card); }

        .status-chip { font-size: 0.65rem; padding: 0.25rem 0.5rem; border-radius: 999px; text-transform: uppercase; letter-spacing: 0.04em; border: 1px solid transparent; }
        .status-chip.active { background: var(--chip-active-bg); color: var(--chip-active-color); border-color: transparent; }
        .status-chip.inactive { background: var(--chip-inactive-bg); color: var(--chip-inactive-color); }
        .status-chip.trial { background: rgba(234,179,8,0.15); color: #facc15; border-color: rgba(234,179,8,0.3); }

        .hero-chip,
        .category-pill { background: var(--surface-muted); color: var(--text-secondary); border-radius: 999px; padding: 0.3rem 0.7rem; font-size: 0.7rem; }
    </style>
</head>
<body style="background: var(--page-bg); color: var(--text-primary); min-height: 100vh; font-family: Inter, system-ui, sans-serif; margin: 0;">

<?php if (AuthManager::isAuthenticated()): ?>
    <?php require_once __DIR__ . '/navigation.php'; renderNavigationNew('Design System', $currentTheme); ?>
    <main style="margin-left: 0; padding: 2rem;" class="md:ml-56">
<?php else: ?>
    <main style="padding: 2rem;">
<?php endif; ?>

<div style="max-width: 1200px; margin: 0 auto;">

    <!-- Header -->
    <div class="dashboard-card" style="padding: 2rem; margin-bottom: 2rem;">
        <div style="display: flex; justify-content: space-between; align-items: flex-start; flex-wrap: wrap; gap: 1rem;">
            <div>
                <h1 style="font-size: 2rem; font-weight: 700; color: var(--text-primary); margin: 0 0 0.5rem 0;">Keelance Design System</h1>
                <p style="color: var(--text-muted); margin: 0 0 1rem 0;">Living style guide with full light/dark mode support</p>
                <div style="display: flex; gap: 0.5rem;">
                    <span class="status-chip active">v1.0</span>
                    <span id="theme-badge" class="status-chip inactive">Dark</span>
                </div>
            </div>
            <button onclick="togglePageTheme()" id="theme-btn" class="btn-emerald" style="padding: 0.5rem 1rem; display: flex; align-items: center; gap: 0.5rem;">
                <svg id="icon-moon" style="width: 1rem; height: 1rem;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"></path>
                </svg>
                <svg id="icon-sun" style="width: 1rem; height: 1rem; display: none;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"></path>
                </svg>
                <span id="theme-text">Switch to Light</span>
            </button>
        </div>
    </div>

    <!-- Colors -->
    <section class="ds-section">
        <h2 class="ds-title">Color System</h2>
        <div class="dashboard-card" style="padding: 1.5rem;">
            <h3 class="ds-subtitle">Current Theme Colors</h3>
            <div class="ds-grid">
                <div class="ds-swatch" style="background: var(--page-bg);">--page-bg</div>
                <div class="ds-swatch" style="background: var(--surface-card);">--surface-card</div>
                <div class="ds-swatch" style="background: var(--surface-base);">--surface-base</div>
                <div class="ds-swatch" style="background: var(--surface-muted);">--surface-muted</div>
                <div class="ds-swatch" style="background: var(--accent);">--accent</div>
            </div>
        </div>
    </section>

    <!-- Buttons -->
    <section class="ds-section">
        <h2 class="ds-title">Buttons</h2>
        <div class="dashboard-card" style="padding: 1.5rem;">
            <div style="display: flex; flex-wrap: wrap; gap: 1rem; margin-bottom: 1rem;">
                <button class="btn-emerald">Primary Button</button>
                <button class="btn-secondary">Secondary Button</button>
                <button class="btn-danger">Danger Button</button>
                <button class="btn-icon"><svg style="width:1rem;height:1rem;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg></button>
            </div>
            <div class="ds-code">.btn-emerald | .btn-secondary | .btn-danger | .btn-icon</div>
        </div>
    </section>

    <!-- Cards -->
    <section class="ds-section">
        <h2 class="ds-title">Cards</h2>
        <div class="ds-grid">
            <div class="dashboard-card" style="padding: 1.5rem;">
                <h3 style="color: var(--text-primary); font-weight: 600; margin: 0 0 0.5rem 0;">Dashboard Card</h3>
                <p class="ds-text">.dashboard-card</p>
            </div>
            <div class="stat-card">
                <p class="stat-label">Stat Card</p>
                <p class="stat-value">1,234</p>
            </div>
            <div class="metric-card">
                <p style="font-size: 0.625rem; text-transform: uppercase; letter-spacing: 0.1em; color: var(--text-muted); margin: 0;">Metric</p>
                <p style="font-size: 1.5rem; font-weight: 600; color: var(--text-primary); margin: 0.25rem 0 0 0;">$12,345</p>
            </div>
            <div class="action-card" style="display: flex; align-items: center; gap: 0.75rem;">
                <div style="width: 2.5rem; height: 2.5rem; border-radius: 0.75rem; background: var(--accent-muted); display: flex; align-items: center; justify-content: center;">
                    <svg style="width: 1rem; height: 1rem; color: var(--accent);" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                </div>
                <div>
                    <p style="font-weight: 600; color: var(--text-primary); margin: 0; font-size: 0.875rem;">Action Card</p>
                    <p style="color: var(--text-muted); margin: 0; font-size: 0.75rem;">Click to action</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Forms -->
    <section class="ds-section">
        <h2 class="ds-title">Form Elements</h2>
        <div class="dashboard-card" style="padding: 1.5rem;">
            <div style="display: grid; gap: 1rem; max-width: 400px;">
                <div>
                    <label class="form-label">Text Input</label>
                    <input type="text" class="form-input" placeholder="Enter text...">
                </div>
                <div>
                    <label class="form-label">Select</label>
                    <select class="form-select">
                        <option>Option 1</option>
                        <option>Option 2</option>
                    </select>
                </div>
                <div>
                    <label class="form-label">Textarea</label>
                    <textarea class="form-textarea" rows="3" placeholder="Enter description..."></textarea>
                </div>
            </div>
        </div>
    </section>

    <!-- Status Banners -->
    <section class="ds-section">
        <h2 class="ds-title">Status Banners</h2>
        <div style="display: grid; gap: 0.75rem;">
            <?php renderStatusBanner('success', 'Success! Operation completed.'); ?>
            <?php renderStatusBanner('error', 'Error! Something went wrong.'); ?>
            <?php renderStatusBanner('warning', 'Warning! Please review.'); ?>
            <?php renderStatusBanner('info', 'Info: Your changes are saved.'); ?>
        </div>
    </section>

    <!-- Chips -->
    <section class="ds-section">
        <h2 class="ds-title">Chips & Badges</h2>
        <div class="dashboard-card" style="padding: 1.5rem;">
            <div style="display: flex; flex-wrap: wrap; gap: 0.5rem;">
                <span class="status-chip active">Active</span>
                <span class="status-chip inactive">Inactive</span>
                <span class="status-chip trial">Trial</span>
                <span class="hero-chip">Hero Chip</span>
                <span class="category-pill">Category</span>
            </div>
        </div>
    </section>

    <!-- Typography -->
    <section class="ds-section">
        <h2 class="ds-title">Typography</h2>
        <div class="dashboard-card" style="padding: 1.5rem;">
            <div style="display: grid; gap: 1rem;">
                <div>
                    <p class="page-title">Page Title (.page-title)</p>
                </div>
                <div>
                    <p class="page-subtitle">Page subtitle text (.page-subtitle)</p>
                </div>
                <div>
                    <p class="section-title">Section Title (.section-title)</p>
                </div>
                <div>
                    <p class="label-uppercase">Uppercase Label (.label-uppercase)</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Hero Components -->
    <section class="ds-section">
        <h2 class="ds-title">Hero Components</h2>
        <?php renderPageHero('DASHBOARD', 'Welcome to Demo Workspace', 'Overview of your workspace activity and stats.'); ?>
        <div style="height: 1rem;"></div>
        <?php renderPageHeroWithStats('LIBRARY', 'Templates', 'Manage your proposal templates.', [
            ['label' => 'Total', 'value' => '24', 'type' => 'primary'],
            ['label' => 'Active', 'value' => '18', 'type' => 'neutral']
        ]); ?>
    </section>

</div>

</main>

<script>
// Theme toggle - WORKING VERSION
function togglePageTheme() {
    console.log('Page theme toggle called');
    var html = document.documentElement;
    var current = html.getAttribute('data-theme') || 'dark';
    var next = current === 'dark' ? 'light' : 'dark';
    
    console.log('Page - Current:', current, 'Next:', next);
    
    html.setAttribute('data-theme', next);
    localStorage.setItem('theme', next);
    updateThemeUI(next);
    
    // Sync navigation
    syncNavigation(next);
}

function updateThemeUI(theme) {
    var moon = document.getElementById('icon-moon');
    var sun = document.getElementById('icon-sun');
    var text = document.getElementById('theme-text');
    var badge = document.getElementById('theme-badge');
    
    console.log('Page UI update - Icons found:', !!moon, !!sun, !!text, !!badge);
    
    if (theme === 'light') {
        if (moon) moon.style.display = 'none';
        if (sun) sun.style.display = 'block';
        if (text) text.textContent = 'Switch to Dark';
        if (badge) {
            badge.textContent = 'Light';
            badge.className = 'status-chip trial';
        }
    } else {
        if (moon) moon.style.display = 'block';
        if (sun) sun.style.display = 'none';
        if (text) text.textContent = 'Switch to Light';
        if (badge) {
            badge.textContent = 'Dark';
            badge.className = 'status-chip inactive';
        }
    }
}

function syncNavigation(theme) {
    var navMoon = document.getElementById('theme-icon-dark');
    var navSun = document.getElementById('theme-icon-light');
    var navLabel = document.getElementById('theme-label');
    
    console.log('Nav sync - Icons found:', !!navMoon, !!navSun, !!navLabel);
    
    if (navMoon && navSun && navLabel) {
        if (theme === 'light') {
            navMoon.style.display = 'none';
            navSun.style.display = 'block';
            navLabel.textContent = 'Light Mode';
        } else {
            navMoon.style.display = 'block';
            navSun.style.display = 'none';
            navLabel.textContent = 'Dark Mode';
        }
    }
}

// Initialize IMMEDIATELY
(function() {
    var saved = localStorage.getItem('theme') || 'dark';
    var html = document.documentElement;
    html.setAttribute('data-theme', saved);
    
    console.log('Page initial theme:', saved);
    
    setTimeout(function() {
        updateThemeUI(saved);
        syncNavigation(saved);
    }, 100);
})();
</script>

</body>
</html>
