<?php
require_once __DIR__ . '/../src/db.php';

// Handle workspace switching with proper username support
$workspaceId = $_GET['id'] ?? 1;
$pdo = getPDO();

// Try to find company by ID first
$stmt = $pdo->prepare("SELECT * FROM companies WHERE id = ?");
$stmt->execute([$workspaceId]);
$company = $stmt->fetch();

if ($company) {
    // Use username if available, otherwise use ID
    $workspaceParam = $company['username'] ?? $company['id'];
    
    // Update session
    session_start();
    $_SESSION['current_company_id'] = $company['id'];
    $_SESSION['current_company'] = $company;
    
    header("Location: index.php?workspace=$workspaceParam");
} else {
    // Fallback to default
    header("Location: index.php");
}
exit;
?>
