// Client and Proposal Search System
function setupSearchableDropdowns() {
    // Client Search
    const clientSelect = document.querySelector('select[name="client_id"]');
    if (clientSelect) {
        const clientSearchContainer = document.createElement('div');
        clientSearchContainer.className = 'relative';
        clientSelect.parentNode.insertBefore(clientSearchContainer, clientSelect);
        clientSearchContainer.appendChild(clientSelect);
        
        const clientSearchInput = document.createElement('input');
        clientSearchInput.type = 'text';
        clientSearchInput.placeholder = 'Search clients...';
        clientSearchInput.className = 'mt-1 w-full px-3 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-slate-500 focus:border-slate-500';
        clientSearchContainer.insertBefore(clientSearchInput, clientSelect);
        
        clientSelect.style.display = 'none';
        
        const clientResultsDiv = document.createElement('div');
        clientResultsDiv.className = 'absolute z-10 w-full mt-1 bg-white border border-slate-300 rounded-lg shadow-lg max-h-60 overflow-y-auto hidden';
        clientSearchContainer.appendChild(clientResultsDiv);
        
        const clients = Array.from(clientSelect.options).slice(1).map(option => ({
            id: option.value,
            name: option.text,
            element: option
        }));
        
        clientSearchInput.addEventListener('input', function() {
            const query = this.value.toLowerCase();
            clientResultsDiv.innerHTML = '';
            
            if (query.length === 0) {
                clientResultsDiv.classList.add('hidden');
                return;
            }
            
            const filtered = clients.filter(client => 
                client.name.toLowerCase().includes(query)
            );
            
            if (filtered.length === 0) {
                clientResultsDiv.innerHTML = '<div class="p-3 text-slate-500">No clients found</div>';
            } else {
                filtered.forEach(client => {
                    const item = document.createElement('div');
                    item.className = 'p-3 hover:bg-slate-50 cursor-pointer border-b border-slate-100 last:border-b-0';
                    item.textContent = client.name;
                    item.addEventListener('click', function() {
                        clientSelect.value = client.id;
                        clientSearchInput.value = client.name;
                        clientResultsDiv.classList.add('hidden');
                    });
                    clientResultsDiv.appendChild(item);
                });
            }
            
            clientResultsDiv.classList.remove('hidden');
        });
        
        clientSearchInput.addEventListener('focus', function() {
            if (this.value.length > 0) {
                this.dispatchEvent(new Event('input'));
            }
        });
        
        document.addEventListener('click', function(e) {
            if (!clientSearchContainer.contains(e.target)) {
                clientResultsDiv.classList.add('hidden');
            }
        });
    }
    
    // Proposal Search
    const proposalSelect = document.querySelector('select[name="proposal_id"]');
    if (proposalSelect) {
        const proposalSearchContainer = document.createElement('div');
        proposalSearchContainer.className = 'relative';
        proposalSelect.parentNode.insertBefore(proposalSearchContainer, proposalSelect);
        proposalSearchContainer.appendChild(proposalSelect);
        
        const proposalSearchInput = document.createElement('input');
        proposalSearchInput.type = 'text';
        proposalSearchInput.placeholder = 'Search proposals...';
        proposalSearchInput.className = 'mt-1 w-full px-3 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-slate-500 focus:border-slate-500';
        proposalSearchContainer.insertBefore(proposalSearchInput, proposalSelect);
        
        proposalSelect.style.display = 'none';
        
        const proposalResultsDiv = document.createElement('div');
        proposalResultsDiv.className = 'absolute z-10 w-full mt-1 bg-white border border-slate-300 rounded-lg shadow-lg max-h-60 overflow-y-auto hidden';
        proposalSearchContainer.appendChild(proposalResultsDiv);
        
        const proposals = Array.from(proposalSelect.options).slice(1).map(option => ({
            id: option.value,
            name: option.text,
            element: option
        }));
        
        proposalSearchInput.addEventListener('input', function() {
            const query = this.value.toLowerCase();
            proposalResultsDiv.innerHTML = '';
            
            if (query.length === 0) {
                proposalResultsDiv.classList.add('hidden');
                return;
            }
            
            const filtered = proposals.filter(proposal => 
                proposal.name.toLowerCase().includes(query)
            );
            
            if (filtered.length === 0) {
                proposalResultsDiv.innerHTML = '<div class="p-3 text-slate-500">No proposals found</div>';
            } else {
                filtered.forEach(proposal => {
                    const item = document.createElement('div');
                    item.className = 'p-3 hover:bg-slate-50 cursor-pointer border-b border-slate-100 last:border-b-0';
                    item.textContent = proposal.name;
                    item.addEventListener('click', function() {
                        proposalSelect.value = proposal.id;
                        proposalSearchInput.value = proposal.name;
                        proposalResultsDiv.classList.add('hidden');
                    });
                    proposalResultsDiv.appendChild(item);
                });
            }
            
            proposalResultsDiv.classList.remove('hidden');
        });
        
        proposalSearchInput.addEventListener('focus', function() {
            if (this.value.length > 0) {
                this.dispatchEvent(new Event('input'));
            }
        });
        
        document.addEventListener('click', function(e) {
            if (!proposalSearchContainer.contains(e.target)) {
                proposalResultsDiv.classList.add('hidden');
            }
        });
    }
}

// Initialize when DOM is ready
document.addEventListener('DOMContentLoaded', setupSearchableDropdowns);
