<?php
session_start();
header('Content-Type: application/json');

$companyId = (int) ($_POST['company_id'] ?? 0);

if ($companyId) {
    require_once __DIR__ . '/../src/db.php';
    $pdo = getPDO();
    $stmt = $pdo->prepare("SELECT * FROM companies WHERE id = ?");
    $stmt->execute([$companyId]);
    $company = $stmt->fetch();
    
    if ($company) {
        $_SESSION['current_company_id'] = $company['id'];
        $_SESSION['current_company'] = $company;
        
        echo json_encode([
            'success' => true,
            'company_name' => $company['name'],
            'message' => 'Switched to ' . $company['name']
        ]);
        exit;
    }
}

echo json_encode(['success' => false, 'message' => 'Failed to switch']);
?>
