<?php
require_once __DIR__ . '/../src/Auth/AuthManager.php';
require_once __DIR__ . '/../src/Auth/AuthManager.php';
require_once __DIR__ . '/../src/MultiTenant/TenantManager.php';

// Require authentication
AuthManager::requireAuth();

// Initialize tenant context
TenantManager::initialize();
require_once __DIR__ . '/../src/Auth/AuthManager.php';
require_once __DIR__ . '/../src/MultiTenant/TenantManager.php';

// Require authentication
AuthManager::requireAuth();

// Initialize tenant context
TenantManager::initialize();
require_once __DIR__ . '/../src/MultiTenant/TenantManager.php';

// Require authentication
AuthManager::requireAuth();

// Initialize tenant context
TenantManager::initialize();
<?php
declare(strict_types=1);

// Simple image upload handler for CKEditor
header('Content-Type: application/json');

try {
    // Check if file was uploaded (TinyMCE uses 'file' or 'upload')
    $fileField = null;
    if (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) {
        $fileField = 'file';
    } elseif (isset($_FILES['upload']) && $_FILES['upload']['error'] === UPLOAD_ERR_OK) {
        $fileField = 'upload';
    } else {
        throw new Exception('No file uploaded or upload error');
    }

    $file = $_FILES[$fileField];
    $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
    
    if (!in_array($file['type'], $allowedTypes, true)) {
        throw new Exception('Invalid file type. Only JPG, PNG, GIF, and WebP are allowed.');
    }

    // Create upload directory if it doesn't exist
    $uploadDir = __DIR__ . '/assets/uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    // Generate unique filename
    $filename = uniqid('img_', true) . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
    $destination = $uploadDir . $filename;

    // Move uploaded file
    if (!move_uploaded_file($file['tmp_name'], $destination)) {
        throw new Exception('Failed to save uploaded file');
    }

    // Return success response in CKEditor format
    $publicPath = '/assets/uploads/' . $filename;
    
    echo json_encode([
        'uploaded' => true,
        'url' => $publicPath,
        'filename' => $filename
    ]);

} catch (Exception $e) {
    // Return error response in CKEditor format
    echo json_encode([
        'uploaded' => false,
        'error' => [
            'message' => $e->getMessage()
        ]
    ]);
}
?>
