<?php
// Simple log viewer for debugging
error_log("=== Testing error logging ===");
echo "<h1>PHP Error Log Test</h1>";
echo "<p>If you can see this page, error logging should work.</p>";
echo "<p>Try saving invoice settings and check what gets logged.</p>";

// Try to write to a custom log file
$logFile = __DIR__ . '/debug.log';
file_put_contents($logFile, "=== Debug log started at " . date('Y-m-d H:i:s') . " ===\n", FILE_APPEND);
echo "<p>Custom debug log created at: " . $logFile . "</p>";

// Show recent entries from our custom log
if (file_exists($logFile)) {
    $lines = file($logFile);
    $recentLines = array_slice($lines, -20); // Last 20 lines
    echo "<h2>Recent Debug Log Entries:</h2>";
    echo "<pre style='background: #f0f0f0; padding: 10px; border: 1px solid #ccc;'>";
    foreach ($recentLines as $line) {
        echo htmlspecialchars($line);
    }
    echo "</pre>";
}
?>
