<?php

require_once __DIR__ . '/src/db.php';

try {
    $pdo = getPDO();
    
    echo "Starting database reset...\n";
    
    // Delete all proposals
    $stmt = $pdo->prepare("DELETE FROM proposals");
    $stmt->execute();
    echo "Deleted all proposals\n";
    
    // Delete all modules
    $stmt = $pdo->prepare("DELETE FROM modules");
    $stmt->execute();
    echo "Deleted all modules\n";
    
    // Delete all templates
    $stmt = $pdo->prepare("DELETE FROM templates");
    $stmt->execute();
    echo "Deleted all templates\n";
    
    // Reset auto-increment counters for SQLite
    $pdo->exec("DELETE FROM sqlite_sequence WHERE name IN ('proposals', 'modules', 'templates')");
    echo "Reset auto-increment counters\n";
    
    echo "\nDatabase reset complete!\n";
    echo "All modules, templates, and proposals have been removed.\n";
    echo "You can now start fresh!\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
