<?php

declare(strict_types=1);

require_once __DIR__ . '/src/db.php';

if ($argc < 2) {
    echo "Usage: php run_migration.php <migration_file.sql>\n";
    exit(1);
}

$migrationFile = $argv[1];

if (!file_exists($migrationFile)) {
    echo "Error: Migration file not found: $migrationFile\n";
    exit(1);
}

$sql = file_get_contents($migrationFile);

if ($sql === false) {
    echo "Error: Could not read migration file\n";
    exit(1);
}

try {
    $pdo = getPDO();
    $pdo->exec($sql);
    echo "✓ Migration completed successfully: $migrationFile\n";
} catch (PDOException $e) {
    echo "✗ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
