const InvoicePDFGenerator = require('./InvoicePDFGenerator');

async function generateReceiptPDF() {
    const args = process.argv.slice(2);
    
    if (args.length < 2) {
        console.error('Usage: node generate_receipt_pdf.js <html_file> <output_pdf>');
        process.exit(1);
    }
    
    const [htmlFile, outputPath] = args;
    const generator = new InvoicePDFGenerator();
    
    try {
        // Read HTML content
        const fs = require('fs');
        const htmlContent = fs.readFileSync(htmlFile, 'utf8');
        
        // Initialize generator
        await generator.init();
        
        // Generate PDF
        const success = await generator.generatePDF(htmlContent, outputPath);
        
        if (success) {
            console.log('Receipt PDF generated successfully:', outputPath);
        } else {
            console.error('Receipt PDF generation failed');
            process.exit(1);
        }
        
    } catch (error) {
        console.error('Receipt PDF generation failed:', error.message);
        process.exit(1);
    } finally {
        await generator.close();
    }
}

generateReceiptPDF();
