<?php

declare(strict_types=1);

require_once __DIR__ . '/ActivityLog.php';

/**
 * Convenience helper for logging workspace activity from any workspace page.
 *
 * Requires secure_workspace.php to have run so that $companyId and $user
 * globals are available.
 */
function workspace_log(
    string $action,
    ?string $entityType = null,
    ?int $entityId = null,
    ?string $entityName = null,
    ?array $oldValues = null,
    ?array $newValues = null
): void {
    // secure_workspace.php sets these globals
    global $companyId, $user;

    if (empty($companyId)) {
        return;
    }

    $userId = isset($user['id']) ? (int) $user['id'] : null;

    try {
        ActivityLog::log(
            (int) $companyId,
            $userId,
            $action,
            $entityType,
            $entityId,
            $entityName,
            $oldValues,
            $newValues
        );
    } catch (Throwable $e) {
        // Logging must never break the main flow
    }
}
