const path = require('path');

/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    path.join(__dirname, 'public/**/*.php'),
    path.join(__dirname, 'public/**/*.js'),
    path.join(__dirname, 'src/**/*.php'),
    path.join(__dirname, 'templates/**/*.php')
  ],
  theme: {
    extend: {
      fontFamily: {
        sans: ['Inter', 'SF Pro Text', '-apple-system', 'BlinkMacSystemFont', 'system-ui', 'sans-serif']
      },
      colors: {
        background: '#05060a',
        surface: '#0b0d14',
        'surface-muted': '#131521',
        border: 'rgba(255, 255, 255, 0.07)',
        'border-strong': 'rgba(255, 255, 255, 0.12)',
        text: '#f4f4f5',
        'text-muted': '#a1a1aa',
        emerald: '#10b981'
      }
    },
  },
  plugins: [],
};

