<?php
$isEmbedPreview = defined('INVOICE_PREVIEW_EMBED') && INVOICE_PREVIEW_EMBED;

if (!$isEmbedPreview):
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Invoice <?= h($invoiceNumber) ?></title>
<?php
endif;
?>
    <style>
        @page { size: A4; margin: 20mm; }
        .invoice-template-body { 
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; 
            font-size: 14px; 
            line-height: 1.6; 
            margin: 0; 
            padding: 0; 
            color: #1a1a1a; 
            background: white; 
        }
        .invoice-container { padding: 12px; background: white; max-width: 800px; margin: 0 auto; }
        .header { border-bottom: 1px solid #e5e5e5; padding-bottom: 20px; margin-bottom: 20px; }
        .header-flex { display: flex; justify-content: space-between; align-items: flex-start; }
        .logo { max-width: 120px; max-height: 40px; object-fit: contain; }
        .logo-placeholder { width: 120px; height: 40px; background: #f8f9fa; border: 1px solid #e5e5e5; border-radius: 4px; display: flex; align-items: center; justify-content: center; }
        .logo-text { color: #9ca3af; font-size: 12px; font-weight: 500; }
        .invoice-title { font-size: 28px; font-weight: 600; color: #1a1a1a; letter-spacing: -0.5px; }
        .invoice-number { font-size: 18px; font-weight: 700; color: #1a1a1a; margin-top: 4px; }
        .invoice-dates { font-size: 14px; color: #6b7280; margin-top: 8px; line-height: 1.5; }
        .grid-2 { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px; }
        .section-title { font-size: 11px; font-weight: 600; color: #6b7280; margin-bottom: 16px; text-transform: uppercase; letter-spacing: 0.5px; }
        .company-name { font-weight: 600; color: #1a1a1a; font-size: 16px; margin-bottom: 4px; }
        .company-legal { font-weight: 400; color: #6b7280; font-size: 14px; margin-bottom: 8px; }
        .address { font-size: 14px; color: #6b7280; white-space: pre-line; word-break: break-word; margin-bottom: 12px; line-height: 1.5; }
        .contact { font-size: 14px; color: #6b7280; margin-top: 12px; line-height: 1.5; }
        .contact-item { margin-bottom: 4px; display: flex; align-items: center; }
        .contact-item svg { width: 14px; height: 14px; margin-right: 6px; opacity: 0.6; }
        .company-meta { margin-top: 16px; font-size: 12px; color: #6b7280; }
        .meta-item { margin-bottom: 4px; }
        .meta-label { font-weight: 600; color: #4b5563; }
        .payment-terms { margin-top: 16px; font-size: 13px; color: #4b5563; }
        .subject { margin-bottom: 20px; }
        .subject-title { font-size: 16px; font-weight: 600; color: #1a1a1a; }
        .project-info { margin-top: 12px; font-size: 13px; color: #6b7280; }
        .project-info div { margin-bottom: 4px; display: flex; align-items: center; }
        .project-info svg { width: 14px; height: 14px; margin-right: 6px; opacity: 0.6; }
        .items-table { width: 100%; margin-bottom: 20px; border-collapse: collapse; table-layout: fixed; }
        .items-table th { text-align: left; padding: 8px 6px; font-size: 11px; font-weight: 600; color: #6b7280; border-bottom: 2px solid #e5e5e5; background: #fafbfc; text-transform: uppercase; letter-spacing: 0.5px; }
        .items-table th.w-40 { width: 45%; }
        .items-table th.w-12 { width: 10%; }
        .items-table th.w-20 { width: 11%; }
        .items-table td { padding: 10px 6px; font-size: 13px; color: #1a1a1a; border-bottom: 1px solid #f5f5f5; vertical-align: top; }
        .items-table td.text-right { text-align: right; }
        .item-name { font-weight: 600; word-break: break-word; color: #1a1a1a; line-height: 1.4; }
        .item-desc { font-size: 12px; color: #6b7280; margin-top: 4px; word-break: break-word; line-height: 1.4; }
        .currency-amount { font-weight: 600; white-space: nowrap; }
        .totals { display: flex; justify-content: flex-end; margin-bottom: 20px; }
        .totals-box { width: 280px; border: 1px solid #e5e5e5; border-radius: 4px; overflow: hidden; }
        .total-row { display: flex; justify-content: space-between; align-items: center; padding: 10px 16px; border-bottom: 1px solid #f5f5f5; background: white; }
        .total-row:last-child { border-bottom: none; }
        .total-label { font-size: 14px; color: #6b7280; font-weight: 500; }
        .total-value { font-size: 14px; font-weight: 600; color: #1a1a1a; }
        .total-grand { background: #1a1a1a; padding: 12px; margin: 0; }
        .total-grand .total-label { color: white; font-weight: 600; font-size: 14px; }
        .total-grand .total-value { color: white; font-size: 18px; font-weight: 700; }
        .payment-info { border-top: 1px solid #e5e5e5; padding-top: 20px; margin-bottom: 20px; }
        .payment-info-title { font-size: 11px; font-weight: 600; color: #6b7280; margin-bottom: 16px; text-transform: uppercase; letter-spacing: 0.5px; }
        .payment-details { font-size: 13px; color: #6b7280; line-height: 1.5; }
        .payment-details div { margin-bottom: 8px; line-height: 1.5; }
        .payment-details div:last-child { margin-bottom: 0; }
        .payment-details .label { font-weight: 600; color: #1a1a1a; display: inline-block; min-width: 120px; }
        .tax-exempt { color: #10b981; font-weight: 600; }
        .notes-section { margin-bottom: 20px; }
        .notes-title { font-size: 11px; font-weight: 600; color: #6b7280; margin-bottom: 12px; text-transform: uppercase; letter-spacing: 0.5px; }
        .notes-content { font-size: 14px; color: #6b7280; line-height: 1.5; }
        .tax-info { margin-bottom: 20px; }
        .tax-title { font-size: 11px; font-weight: 600; color: #6b7280; margin-bottom: 12px; text-transform: uppercase; letter-spacing: 0.5px; }
        .tax-details { font-size: 13px; color: #6b7280; line-height: 1.5; }
        .signatory-section { margin-top: 40px; border-top: 1px solid #e5e5e5; padding-top: 30px; }
        .signatory-block { display: flex; flex-direction: column; align-items: flex-start; gap: 15px; }
        .signature-container { display: flex; flex-direction: column; align-items: flex-start; }
        .signature-image { max-height: 60px; margin-bottom: 8px; }
        .signatory-line { width: 250px; height: 1px; background: #d1d5db; margin-bottom: 16px; }
        .signatory-details { text-align: left; font-size: 14px; color: #374151; line-height: 1.5; }
        .signatory-name { font-weight: 600; color: #1a1a1a; font-size: 16px; margin-bottom: 4px; }
        .signatory-designation { color: #6b7280; font-size: 14px; margin-bottom: 8px; }
        .signatory-company { font-size: 13px; color: #374151; font-weight: 500; margin-bottom: 20px; }
    </style>
<?php if (!$isEmbedPreview): ?>
</head>
<body class="invoice-template-body">
<?php else: ?>
<div class="invoice-template-body">
<?php endif; ?>
    <div class="invoice-container">
        <!-- Invoice Header -->
        <div class="header">
            <div class="header-flex">
                <!-- Left: Logo -->
                <div>
                    <?php if (!empty($settings['company_logo_path'])): ?>
                        <?php 
                        // Convert to absolute file path and encode as base64 for Puppeteer
                        $logoPath = $settings['company_logo_path'];
                        if (strpos($logoPath, '/') === 0) {
                            $logoPath = __DIR__ . '/../public' . $logoPath;
                        }
                        
                        if (file_exists($logoPath)) {
                            $imageData = base64_encode(file_get_contents($logoPath));
                            $mimeType = mime_content_type($logoPath);
                            $logoSrc = 'data:' . $mimeType . ';base64,' . $imageData;
                        } else {
                            $logoSrc = '';
                            error_log("Logo file not found: " . $logoPath);
                        }
                        ?>
                        <?php if (!empty($logoSrc)): ?>
                            <img src="<?= h($logoSrc) ?>" alt="Company Logo" class="logo">
                        <?php else: ?>
                            <div class="logo-placeholder">
                                <span class="logo-text">LOGO</span>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="logo-placeholder">
                            <span class="logo-text">LOGO</span>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- Right: Invoice Details -->
                <div style="text-align: right;">
                    <div class="invoice-title">INVOICE</div>
                    <div class="invoice-number"><?= h($invoiceNumber) ?></div>
                    <div class="invoice-dates">
                        <div>Date: <?= date('M j, Y', strtotime($invoiceData['issue_date'] ?? date('Y-m-d'))) ?></div>
                        <div>Due: <?= date('M j, Y', strtotime($invoiceData['due_date'] ?? date('Y-m-d', strtotime('+30 days')))) ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Company and Client Info -->
        <div class="grid-2">
            <div>
                <div class="section-title">FROM</div>
                <div>
                    <div class="company-name"><?= h($settings['company_name'] ?? 'Your Company') ?></div>
                    <?php if (!empty($settings['company_legal_name'])): ?>
                        <div class="company-legal"><?= h($settings['company_legal_name']) ?></div>
                    <?php endif; ?>
                    <div class="address">
                        <?php 
                        $addressParts = [];
                        if (!empty($settings['address_line_1'])) $addressParts[] = $settings['address_line_1'];
                        if (!empty($settings['address_line_2'])) $addressParts[] = $settings['address_line_2'];
                        if (!empty($settings['city'])) $addressParts[] = $settings['city'];
                        if (!empty($settings['state'])) $addressParts[] = $settings['state'];
                        if (!empty($settings['zip_code'])) $addressParts[] = $settings['zip_code'];
                        if (!empty($settings['country'])) $addressParts[] = $settings['country'];
                        echo h(implode("\n", $addressParts));
                        ?>
                    </div>
                    <div class="contact">
                        <?php if (!empty($settings['company_email'])): ?>
                            <div class="contact-item">
                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                </svg>
                                <?= h($settings['company_email']) ?>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($settings['company_phone'])): ?>
                            <div class="contact-item">
                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                                </svg>
                                <?= h($settings['company_phone']) ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Company Meta Information -->
                    <?php if (!empty($settings['tax_name']) || !empty($settings['tax_id']) || !empty($settings['company_id']) || !empty($settings['company_registration_number'])): ?>
                        <div class="company-meta">
                            <?php if (!empty($settings['tax_name']) && !empty($settings['tax_id'])): ?>
                                <div class="meta-item"><span class="meta-label"><?= h($settings['tax_name']) ?>:</span> <?= h($settings['tax_id']) ?></div>
                            <?php endif; ?>
                            <?php if (!empty($settings['company_id']) && !empty($settings['company_registration_number'])): ?>
                                <div class="meta-item"><?= h($settings['company_id']) ?>: <?= h($settings['company_registration_number']) ?></div>
                            <?php elseif (!empty($settings['company_id'])): ?>
                                <div class="meta-item"><?= h($settings['company_id']) ?></div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Custom Meta Fields -->
                    <?php 
                    $customMeta = [];
                    if (!empty($settings['custom_meta'])) {
                        $customMeta = json_decode($settings['custom_meta'], true) ?: [];
                    }
                    ?>
                    <?php if (!empty($customMeta)): ?>
                        <div class="company-meta">
                            <?php foreach ($customMeta as $label => $value): ?>
                                <div class="meta-item"><span class="meta-label"><?= h($label) ?>:</span> <?= h($value) ?></div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div>
                <div class="section-title">BILL TO</div>
                <div>
                    <?php if (!empty($invoiceData['client_info']['name'])): ?>
                        <?php 
                        // Calculate display name based on selection or use stored display name
                        $displayName = $invoiceData['display_name'] ?? null;
                        if (empty($displayName)) {
                            // Fallback calculation if display_name is not stored
                            $displayOption = $invoiceData['display_name_option'] ?? 'client_name';
                            switch ($displayOption) {
                                case 'company_name':
                                    $displayName = $invoiceData['client_info']['company_name'] ?? $invoiceData['client_info']['name'];
                                    break;
                                case 'custom':
                                    $displayName = $invoiceData['custom_display_name'] ?? $invoiceData['client_info']['name'];
                                    break;
                                case 'client_name':
                                default:
                                    $displayName = $invoiceData['client_info']['name'];
                                    break;
                            }
                        }
                        ?>
                        <div class="company-name"><?= h($displayName) ?></div>
                        <?php if (!empty($invoiceData['client_info']['address'])): ?>
                            <div class="address"><?= h($invoiceData['client_info']['address']) ?></div>
                        <?php endif; ?>
                        <div class="contact">
                            <?php if (!empty($invoiceData['client_info']['email'])): ?>
                                <div class="contact-item">
                                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                    </svg>
                                    <?= h($invoiceData['client_info']['email']) ?>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($invoiceData['client_info']['phone'])): ?>
                                <div class="contact-item">
                                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                                    </svg>
                                    <?= h($invoiceData['client_info']['phone']) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Payment Terms -->
                        <?php 
                        $paymentTerms = $invoiceData['payment_terms'] ?? ($settings['default_payment_terms'] ?? 'Due on Receipt');
                        ?>
                        <div class="payment-terms">
                            <strong>Payment Terms:</strong> <?= h($paymentTerms) ?>
                        </div>
                    <?php else: ?>
                        <div style="color: #9ca3af; font-size: 12px; font-style: italic;">No client selected</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Invoice Subject -->
        <?php if (!empty($invoiceData['invoice_subject']) || !empty($invoiceData['project_id']) || !empty($invoiceData['proposal_id']) || !empty($invoiceData['contract_id'])): ?>
            <div class="subject">
                <div class="subject-title"><?= h($invoiceData['invoice_subject'] ?? 'Invoice') ?></div>
                <?php if (!empty($invoiceData['project_id']) || !empty($invoiceData['proposal_id']) || !empty($invoiceData['contract_id'])): ?>
                    <div class="project-info">
                        <?php if (!empty($invoiceData['project_id'])): ?>
                            <div>
                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                </svg>
                                Project ID: <?= h($invoiceData['project_id']) ?>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($invoiceData['proposal_id'])): ?>
                            <div>
                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                Proposal ID: <?= h($invoiceData['proposal_id']) ?>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($invoiceData['contract_id'])): ?>
                            <div>
                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                Contract ID: <?= h($invoiceData['contract_id']) ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <!-- Invoice Items -->
        <div>
            <table class="items-table">
                <thead>
                    <tr>
                        <th style="width: 45%;">Item & Description</th>
                        <th style="width: 10%; text-align: right;">Units</th>
                        <th style="width: 15%; text-align: right;">Price</th>
                        <th style="width: 10%; text-align: right;">Disc</th>
                        <th style="width: 10%; text-align: right;">Tax</th>
                        <th style="width: 10%; text-align: right;">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($invoiceData['items']) && is_array($invoiceData['items'])): ?>
                        <?php foreach ($invoiceData['items'] as $item): ?>
                            <tr>
                                <td style="vertical-align: top; word-wrap: break-word; max-width: 0;">
                                    <div style="font-weight: 600; color: #1a1a1a; line-height: 1.4; word-wrap: break-word;"><?= h($item['item_name']) ?></div>
                                    <?php if (!empty($item['description'])): ?>
                                        <div style="font-size: 12px; color: #6b7280; margin-top: 4px; line-height: 1.4; word-wrap: break-word;"><?= h($item['description']) ?></div>
                                    <?php endif; ?>
                                    <?php if (!empty($item['tax_bracket_name'])): ?>
                                        <div style="font-size: 11px; color: #6b7280; margin-top: 6px; font-style: italic;">
                                            Tax: <?= h($item['tax_bracket_name']) ?> (<?= number_format(($item['tax_bracket_rate'] ?? 0) * 100, 2) ?>%)
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td style="text-align: right; vertical-align: top;"><?= number_format((float) $item['quantity'], 2) ?></td>
                                <td style="text-align: right; vertical-align: top;">
                                    <?= number_format((float) $item['unit_price'], 2) ?>
                                </td>
                                <td style="text-align: right; vertical-align: top;">
                                    <?php if ($item['discount_percent'] > 0): ?>
                                        <?= $item['discount_percent'] ?>%
                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>
                                <td style="text-align: right; vertical-align: top;">
                                    <?php if (!empty($item['tax_amount']) && $item['tax_amount'] > 0): ?>
                                        <?= number_format((float) $item['tax_amount'], 2) ?>
                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>
                                <td style="text-align: right; vertical-align: top; font-weight: 600;">
                                    <?= number_format((float) $item['total'], 2) ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" style="text-align: center; padding: 40px; color: #9ca3af; font-style: italic;">
                                No items added to this invoice
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Totals Section -->
        <div class="totals">
            <div class="totals-box">
                <!-- Subtotal -->
                <div class="total-row">
                    <span class="total-label">Subtotal</span>
                    <span class="total-value">
                        <span class="currency-amount">
                            <?= h($settings['currency'] ?? 'USD') ?> <?= number_format((float) $invoiceData['subtotal'] ?? 0, 2) ?>
                        </span>
                    </span>
                </div>
                
                <!-- Tax -->
                <div class="total-row">
                    <span class="total-label">
                        <?php if ($invoiceData['tax_exempt'] ?? false): ?>
                            Tax (Exempt)
                        <?php else: ?>
                            Tax
                        <?php endif; ?>
                    </span>
                    <span class="total-value">
                        <?php if ($invoiceData['tax_exempt'] ?? false): ?>
                            <span class="tax-exempt">EXEMPT</span>
                        <?php else: ?>
                            <span class="currency-amount">
                                <?= h($settings['currency'] ?? 'USD') ?> <?= number_format((float) $invoiceData['tax_total'] ?? 0, 2) ?>
                            </span>
                        <?php endif; ?>
                    </span>
                </div>
                
                <!-- Total -->
                <div class="total-row total-grand">
                    <span class="total-label">TOTAL</span>
                    <span class="total-value">
                        <span class="currency-amount" style="color: white;">
                            <?= h($settings['currency'] ?? 'USD') ?> <?= number_format((float) $invoiceData['total'] ?? 0, 2) ?>
                        </span>
                    </span>
                </div>
            </div>
        </div>

        <!-- Tax Information -->
        <?php if (!empty($invoiceData['tax_type']) || !empty($invoiceData['tax_brackets']) || ($invoiceData['tax_exempt'] ?? false)): ?>
            <div class="tax-info">
                <div class="tax-title">TAX INFORMATION</div>
                <div class="tax-details">
                    <?php if ($invoiceData['tax_exempt'] ?? false): ?>
                        <div><strong>Tax Status:</strong> <span class="tax-exempt">TAX EXEMPT</span></div>
                        <?php if (!empty($invoiceData['tax_exemption_reason'])): ?>
                            <div><strong>Exemption Reason:</strong> <?= h($invoiceData['tax_exemption_reason']) ?></div>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if (!empty($invoiceData['tax_type'])): ?>
                            <div><strong>Tax Type:</strong> <?= h($invoiceData['tax_type'] === 'per_item' ? 'Per Item' : 'Invoice Level') ?></div>
                            
                            <?php if ($invoiceData['tax_type'] === 'invoice_level' && !empty($invoiceData['invoice_level_tax_bracket'])): ?>
                                <div><strong>Tax Applied:</strong> 
                                    <?= h($invoiceData['invoice_level_tax_bracket']['name'] ?? 'Tax') ?> 
                                    (<?= number_format(($invoiceData['invoice_level_tax_bracket']['rate'] ?? 0) * 100, 2) ?>%)
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        
                        <?php if (!empty($invoiceData['tax_brackets']) && is_array($invoiceData['tax_brackets'])): ?>
                            <div><strong>Tax Brackets Applied:</strong></div>
                            <?php foreach ($invoiceData['tax_brackets'] as $bracket): ?>
                                <div>• <?= h($bracket['name'] ?? 'Tax') ?>: <?= h($bracket['rate'] ?? 0) ?>%</div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Notes Section -->
        <?php if (!empty($invoiceData['notes'])): ?>
            <div class="notes-section">
                <div class="notes-title">NOTES</div>
                <div class="notes-content"><?= h($invoiceData['notes']) ?></div>
            </div>
        <?php endif; ?>

        <!-- Payment Information -->
        <?php if (!empty($settings['bank_name']) || !empty($settings['bank_account_name'])): ?>
            <div class="payment-info">
                <div class="payment-info-title">PAYMENT INFORMATION</div>
                <div class="payment-details">
                    <?php if (!empty($settings['bank_name'])): ?>
                        <div><span class="label">Bank:</span> <?= h($settings['bank_name']) ?></div>
                    <?php endif; ?>
                    <?php if (!empty($settings['bank_account_name'])): ?>
                        <div><span class="label">Account Name:</span> <?= h($settings['bank_account_name']) ?></div>
                    <?php endif; ?>
                    <?php if (!empty($settings['bank_account_number'])): ?>
                        <div><span class="label">Account Number:</span> <?= h($settings['bank_account_number']) ?></div>
                    <?php endif; ?>
                    <?php if (!empty($settings['bank_routing_number'])): ?>
                        <div><span class="label">Routing Number:</span> <?= h($settings['bank_routing_number']) ?></div>
                    <?php endif; ?>
                    <?php if (!empty($settings['bank_swift'])): ?>
                        <div><span class="label">SWIFT Code:</span> <?= h($settings['bank_swift']) ?></div>
                    <?php endif; ?>
                    <?php if (!empty($settings['bank_details'])): ?>
                        <div><span class="label">Additional Details:</span><br><?= h($settings['bank_details']) ?></div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Authorized Signatory -->
        <?php if (!empty($settings['authorized_signatory_name'])): ?>
            <div class="signatory-section">
                <div class="section-title">AUTHORIZED SIGNATORY</div>
                <div class="signatory-block">
                    <div class="signature-container">
                        <div class="signatory-details">
                            <div class="signatory-company">For <?= h($settings['company_legal_name'] ?? $settings['company_name'] ?? 'Your Company') ?></div>
                        </div>
                        
                        <?php if (!empty($settings['authorized_signatory_signature_path'])): ?>
                            <?php 
                            // Convert signature to base64 for PDF
                            $signaturePath = $settings['authorized_signatory_signature_path'];
                            if (strpos($signaturePath, '/') === 0) {
                                $signaturePath = __DIR__ . '/../public' . $signaturePath;
                            }
                            
                            if (file_exists($signaturePath)) {
                                $imageData = base64_encode(file_get_contents($signaturePath));
                                $mimeType = mime_content_type($signaturePath);
                                $signatureSrc = 'data:' . $mimeType . ';base64,' . $imageData;
                                echo '<img src="' . h($signatureSrc) . '" alt="Signature" class="signature-image">';
                            }
                            ?>
                        <?php endif; ?>
                        
                        <div class="signatory-line"></div>
                        <div class="signatory-details">
                            <div class="signatory-name"><?= h($settings['authorized_signatory_name']) ?></div>
                            <?php if (!empty($settings['authorized_signatory_designation'])): ?>
                                <div class="signatory-designation"><?= h($settings['authorized_signatory_designation']) ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php if (!$isEmbedPreview): ?>
</body>
</html>
<?php else: ?>
</div>
<?php endif; ?>
