<?php
require_once __DIR__ . '/src/helpers.php';
require_once __DIR__ . '/src/db.php';
require_once __DIR__ . '/src/TenantDB.php';

// Simulate the workspace context
$_GET['workspace'] = 'pixelvise';

// Load workspace security to set tenant context
require_once __DIR__ . '/src/WorkspaceSecurity.php';

// Get current user and company (simulate auth token)
$sessionToken = 'test'; // This will fail but let's see

try {
    $companyId = TenantDB::getTenant();
    echo "Current tenant ID: " . ($companyId ?: 'NULL') . "\n";
    
    if ($companyId) {
        $pdo = getPDO();
        $stmt = $pdo->prepare("SELECT * FROM clients WHERE company_id = ? ORDER BY created_at DESC");
        $stmt->execute([$companyId]);
        $clients = $stmt->fetchAll();
        echo "Direct query found " . count($clients) . " clients\n";
        
        if (!empty($clients)) {
            echo "First client: " . $clients[0]['name'] . " (ID: " . $clients[0]['id'] . ")\n";
        }
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
