#!/bin/bash

# Script to update all PHP pages to use compiled CSS instead of Tailwind CDN

PUBLIC_DIR="/Users/craiggomes/Documents/Workstation/Projects/Keelance/public"

# Find all PHP files in public directory (excluding admin subdirectory)
find "$PUBLIC_DIR" -maxdepth 1 -name "*.php" -type f | while read -r file; do
    echo "Processing: $file"
    
    # Replace Tailwind CDN with compiled CSS
    sed -i '' 's|<script src="https://cdn.tailwindcss.com"></script>|<link rel="stylesheet" href="/assets/styles/app.build.css">|g' "$file"
    
    echo "  ✓ Updated CSS link"
done

echo ""
echo "✅ All pages updated successfully!"
echo "Remember to rebuild CSS with: npm run build:css"
